/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.types.Path;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.AntSecurityException;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.ant.internal.ui.model.AntModelMessages;
import org.eclipse.ant.internal.ui.model.AntTaskNode;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.xml.sax.Attributes;

public class AntDefiningTaskNode
extends AntTaskNode {
    private String fIdentifier = null;

    public AntDefiningTaskNode(Task task, Attributes attributes) {
        super(task);
        String label = attributes.getValue("name");
        if (label == null) {
            label = task.getTaskName();
            String file = attributes.getValue("file");
            if (file != null) {
                label = String.valueOf(label) + " " + file;
                this.fIdentifier = file;
            } else {
                String resource = attributes.getValue("resource");
                if (resource != null) {
                    label = String.valueOf(label) + " " + resource;
                    this.fIdentifier = resource;
                }
            }
        } else {
            this.fIdentifier = label;
        }
        this.setBaseLabel(label);
    }

    protected ImageDescriptor getBaseImageDescriptor() {
        String taskName = this.getTask().getTaskName();
        if ("taskdef".equalsIgnoreCase(taskName) || "typedef".equalsIgnoreCase(taskName)) {
            return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antTaskdef");
        }
        return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antMacrodef");
    }

    public boolean configure(boolean validateFully) {
        if (this.fConfigured) {
            return false;
        }
        if (this.shouldConfigure()) {
            try {
                ComponentHelper helper = ComponentHelper.getComponentHelper((Project)this.getProjectNode().getProject());
                ((AntModel)this.getAntModel()).removeDefinerTasks(this.getIdentifier(), helper.getAntTypeTable());
                Hashtable old = new Hashtable(helper.getAntTypeTable());
                this.getTask().maybeConfigure();
                this.getTask().execute();
                Iterator newNames = helper.getAntTypeTable().keySet().iterator();
                ArrayList<String> defined = new ArrayList<String>();
                while (newNames.hasNext()) {
                    String name = (String)newNames.next();
                    if (old.get(name) != null) continue;
                    defined.add(name);
                }
                ((AntModel)this.getAntModel()).addDefinedTasks(defined, this);
                return false;
            }
            catch (BuildException be) {
                ((AntModel)this.getAntModel()).removeDefiningTaskNodeInfo(this);
                this.handleBuildException(be, "problem_classpath");
            }
            catch (LinkageError linkageError) {
                ((AntModel)this.getAntModel()).removeDefiningTaskNodeInfo(this);
                this.handleBuildException(new BuildException(AntModelMessages.AntDefiningTaskNode_0), "problem_classpath");
            }
            catch (AntSecurityException antSecurityException) {
                ((AntModel)this.getAntModel()).removeDefiningTaskNodeInfo(this);
                this.handleBuildException(new BuildException(AntModelMessages.AntDefiningTaskNode_1), "problem_security");
            }
        }
        return false;
    }

    public Object getRealTask() {
        Task task = this.getTask();
        if (task instanceof UnknownElement) {
            task.maybeConfigure();
            return ((UnknownElement)task).getRealThing();
        }
        return task;
    }

    protected String getIdentifier() {
        return this.fIdentifier;
    }

    public static void setJavaClassPath() {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        URL[] antClasspath = prefs.getURLs();
        AntDefiningTaskNode.setJavaClassPath(antClasspath);
    }

    public static void setJavaClassPath(URL[] antClasspath) {
        Path systemClasspath;
        StringBuffer buff = new StringBuffer();
        File file = null;
        int i = 0;
        while (i < antClasspath.length) {
            block3: {
                try {
                    file = new File(FileLocator.toFileURL((URL)antClasspath[i]).getPath());
                }
                catch (IOException iOException) {
                    break block3;
                }
                buff.append(file.getAbsolutePath());
                buff.append("; ");
            }
            ++i;
        }
        Path.systemClasspath = systemClasspath = new Path(null, buff.substring(0, buff.length() - 2));
    }

    public boolean collapseProjection() {
        IPreferenceStore store = AntUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("editor_folding_defining");
    }

    public void setLength(int length) {
        super.setLength(length);
        if (this.shouldConfigure()) {
            this.getAntModel().setDefiningTaskNodeText(this);
        }
    }

    private boolean shouldConfigure() {
        IPreferenceStore store = AntUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("content_assist_userDefinedTasks");
    }

    protected void setNeedsToBeConfigured(boolean configure) {
        this.fConfigured = !configure;
    }
}

