/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.synchronize.ThreeWayDiffEntry;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GitSyncObjectCache {
    private final String name;
    private ThreeWayDiffEntry diffEntry;
    private Map<String, GitSyncObjectCache> members;

    GitSyncObjectCache(String name, ThreeWayDiffEntry diffEntry) {
        this.name = name;
        this.diffEntry = diffEntry;
    }

    public String getName() {
        return this.name;
    }

    public ThreeWayDiffEntry getDiffEntry() {
        return this.diffEntry;
    }

    public void addMember(ThreeWayDiffEntry entry) {
        String memberPath = entry.getPath();
        if (this.members == null) {
            this.members = new HashMap<String, GitSyncObjectCache>();
        }
        int start = -1;
        Map<String, GitSyncObjectCache> parent = this.members;
        int separatorIdx = memberPath.indexOf("/");
        while (separatorIdx > 0) {
            String key = memberPath.substring(start + 1, separatorIdx);
            GitSyncObjectCache cacheObject = parent.get(key);
            if (cacheObject == null) {
                throw new RuntimeException(NLS.bind((String)CoreText.GitSyncObjectCache_noData, (Object)key));
            }
            start = separatorIdx;
            separatorIdx = memberPath.indexOf("/", separatorIdx + 1);
            if (cacheObject.members == null) {
                cacheObject.members = new HashMap<String, GitSyncObjectCache>();
            }
            parent = cacheObject.members;
        }
        String newName = start > 0 ? memberPath.substring(start + 1) : memberPath;
        GitSyncObjectCache obj = new GitSyncObjectCache(newName, entry);
        parent.put(newName, obj);
    }

    public GitSyncObjectCache get(String childPath) {
        if (childPath.length() == 0) {
            return this;
        }
        if (childPath.substring(childPath.lastIndexOf("/") + 1, childPath.length()).equals(this.name)) {
            return this;
        }
        if (this.members == null) {
            return null;
        }
        int start = -1;
        Map<String, GitSyncObjectCache> parent = this.members;
        int separatorIdx = childPath.indexOf("/");
        while (separatorIdx > 0) {
            String key = childPath.substring(start + 1, separatorIdx);
            GitSyncObjectCache childObject = parent.get(key);
            if (childObject == null) {
                return null;
            }
            start = separatorIdx;
            separatorIdx = childPath.indexOf("/", separatorIdx + 1);
            parent = childObject.members;
            if (parent != null) continue;
            return null;
        }
        return parent.get(childPath.subSequence(childPath.lastIndexOf("/") + 1, childPath.length()));
    }

    public int membersCount() {
        return this.members != null ? this.members.size() : 0;
    }

    public Collection<GitSyncObjectCache> members() {
        return this.members != null ? this.members.values() : null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("entry: ").append(this.diffEntry).append("\n");
        if (this.members != null) {
            builder.append("members: ");
            for (GitSyncObjectCache obj : this.members.values()) {
                builder.append(obj.toString()).append("\n");
            }
        }
        return builder.toString();
    }

    void merge(GitSyncObjectCache other, Set<String> filterPaths) {
        if (other.members != null) {
            GitSyncObjectCache obj;
            String key;
            if (this.members == null) {
                this.members = new HashMap<String, GitSyncObjectCache>();
            }
            for (Map.Entry<String, GitSyncObjectCache> entry : this.members.entrySet()) {
                String entryPath;
                key = entry.getKey();
                if (other.members.containsKey(key) || !GitSyncObjectCache.containsPathOrParent(filterPaths, entryPath = (obj = entry.getValue()).getDiffEntry().getPath())) continue;
                obj.getDiffEntry().changeType = ThreeWayDiffEntry.ChangeType.IN_SYNC;
            }
            for (Map.Entry<String, GitSyncObjectCache> entry : other.members.entrySet()) {
                key = entry.getKey();
                obj = entry.getValue();
                if (this.members.containsKey(key)) {
                    this.members.get(key).merge(obj, filterPaths);
                    continue;
                }
                this.members.put(key, obj);
            }
        } else if (this.members != null) {
            for (GitSyncObjectCache obj : this.members.values()) {
                String entryPath = obj.getDiffEntry().getPath();
                if (!GitSyncObjectCache.containsPathOrParent(filterPaths, entryPath)) continue;
                obj.getDiffEntry().changeType = ThreeWayDiffEntry.ChangeType.IN_SYNC;
            }
        } else {
            this.diffEntry = other.diffEntry;
        }
    }

    private static boolean containsPathOrParent(Set<String> filterPaths, String pathToTest) {
        if (filterPaths.contains(pathToTest)) {
            return true;
        }
        if (filterPaths.contains("")) {
            return true;
        }
        String path = pathToTest;
        int lastSlash = path.lastIndexOf(47);
        while (lastSlash != -1) {
            if (filterPaths.contains(path = path.substring(0, lastSlash))) {
                return true;
            }
            lastSlash = path.lastIndexOf(47);
        }
        return false;
    }
}

