from pathlib import Path
import shutil
import tempfile
import unittest


class FileTest(unittest.TestCase):
    def setUp(self):
        # Make a temporary directory
        self.tmpdir = Path(tempfile.mkdtemp())

    def test_write(self):
        tmpfile = self.tmpdir / 'tmpfile'
        with open(tmpfile, 'w') as f:
            f.write('What is your favorite color?\n')
        self.assertTrue(tmpfile.exists())

    def tearDown(self):
        shutil.rmtree(self.tmpdir)
