/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.conversion;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.ConversionException;
import org.mvel2.ConversionHandler;
import org.mvel2.conversion.Converter;

public class BooleanCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();
    private static Converter stringConverter = new Converter(){

        public Object convert(Object o) {
            return !((String)o).equalsIgnoreCase("false") && !((String)o).equalsIgnoreCase("no") && !((String)o).equalsIgnoreCase("off") && !"0".equals(o) && !"".equals(o);
        }
    };

    static {
        CNV.put(String.class, stringConverter);
        CNV.put(Object.class, new Converter(){

            public Object convert(Object o) {
                return stringConverter.convert(String.valueOf(o));
            }
        });
        CNV.put(Boolean.class, new Converter(){

            public Object convert(Object o) {
                return o;
            }
        });
        CNV.put(Integer.class, new Converter(){

            public Boolean convert(Object o) {
                if ((Integer)o > 0) {
                    return true;
                }
                return false;
            }
        });
        CNV.put(Float.class, new Converter(){

            public Boolean convert(Object o) {
                if (((Float)o).floatValue() > 0.0f) {
                    return true;
                }
                return false;
            }
        });
        CNV.put(Double.class, new Converter(){

            public Boolean convert(Object o) {
                if ((Double)o > 0.0) {
                    return true;
                }
                return false;
            }
        });
        CNV.put(Short.class, new Converter(){

            public Boolean convert(Object o) {
                if ((Short)o > 0) {
                    return true;
                }
                return false;
            }
        });
        CNV.put(Long.class, new Converter(){

            public Boolean convert(Object o) {
                if ((Long)o > 0L) {
                    return true;
                }
                return false;
            }
        });
        CNV.put(Boolean.TYPE, new Converter(){

            public Boolean convert(Object o) {
                return (boolean)((Boolean)o);
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            public Boolean convert(Object o) {
                return ((BigDecimal)o).doubleValue() > 0.0;
            }
        });
    }

    public Object convertFrom(Object in) {
        if (!CNV.containsKey(in.getClass())) {
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + Boolean.class.getName());
        }
        return CNV.get(in.getClass()).convert(in);
    }

    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }
}

