/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.ui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProvider;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.ExtdocUtils;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class ProviderArea {
    private final ExtdocProvider provider;
    private Composite container;
    private Label separator;
    private Composite title;
    private Composite status;
    private Composite content;
    private final GridLayoutFactory layoutFactory = GridLayoutFactory.fillDefaults().spacing(0, 0);
    private final GridDataFactory layoutDataFactory = GridDataFactory.fillDefaults().grab(true, false);

    public ProviderArea(ExtdocProvider provider) {
        this.provider = provider;
    }

    public void createControl(Composite parent) {
        this.container = this.createComposite(parent);
        this.separator = new Label(this.container, 258);
        this.separator.setLayoutData((Object)this.layoutDataFactory.indent(0, 5).create());
        this.createTitleArea();
        this.status = this.createComposite(this.container);
        this.content = this.createComposite(this.container);
        this.hide();
    }

    private void createTitleArea() {
        this.title = this.createComposite(this.container);
        String providerName = this.provider.getDescription().getName();
        Image providerImage = this.provider.getDescription().getImage();
        CLabel l = new CLabel(this.title, 0);
        l.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        ExtdocUtils.setInfoForegroundColor((Control)l);
        ExtdocUtils.setInfoBackgroundColor((Control)l);
        l.setText(providerName);
        l.setImage(providerImage);
    }

    private Composite createComposite(Composite parent) {
        Composite c = new Composite(parent, 0);
        ExtdocUtils.setInfoBackgroundColor((Control)c);
        c.setLayout((Layout)this.layoutFactory.create());
        c.setLayoutData((Object)this.layoutDataFactory.create());
        return c;
    }

    public Composite getContentArea() {
        return this.content;
    }

    public void showContent() {
        ProviderArea.setVisible(this.title, true);
        ProviderArea.setVisible(this.status, false);
        ProviderArea.setVisible(this.content, true);
        ProviderArea.setVisible(this.container, true);
        this.layout();
    }

    public void showStatus() {
        ProviderArea.setVisible(this.title, true);
        ProviderArea.setVisible(this.status, true);
        ProviderArea.setVisible(this.content, false);
        ProviderArea.setVisible(this.container, true);
        this.layout();
    }

    public void hide() {
        ProviderArea.setVisible(this.title, false);
        ProviderArea.setVisible(this.status, false);
        ProviderArea.setVisible(this.content, false);
        ProviderArea.setVisible(this.container, false);
        this.layout();
    }

    private static void setVisible(Composite d, boolean isVisible) {
        d.setVisible(isVisible);
        Object layoutData = d.getLayoutData();
        if (layoutData instanceof GridData) {
            GridData gridData = (GridData)layoutData;
            gridData.exclude = !isVisible;
        } else {
            Throws.throwUnsupportedOperation((String)"layout of provided composite not supported", (Object[])new Object[0]);
        }
    }

    public void layout() {
        this.status.layout();
        this.content.layout();
        this.container.layout();
    }

    public Point getLocation() {
        return this.container.getLocation();
    }

    public void moveAbove(ProviderArea area) {
        this.container.moveAbove((Control)area.container);
    }

    public void moveBelow(ProviderArea area) {
        this.container.moveBelow((Control)area.container);
    }

    public void cleanup() {
        ProviderArea.disposeChildren(this.status);
        ProviderArea.disposeChildren(this.content);
    }

    private static void disposeChildren(Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
    }

    public void setStatus(String statusMessage) {
        ProviderArea.disposeChildren(this.status);
        Link link = new Link(this.status, 0);
        link.setText(statusMessage);
        link.setBackground(link.getDisplay().getSystemColor(29));
        this.layout();
    }

    public void setStatusWithCallback(String statusMessage, SelectionListener listener) {
        ProviderArea.disposeChildren(this.status);
        Link link = new Link(this.status, 0);
        link.setText(statusMessage);
        link.setBackground(link.getDisplay().getSystemColor(29));
        link.addSelectionListener(listener);
        this.layout();
    }
}

