/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.subwords;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.internal.completion.rcp.subwords.LCSS;
import org.eclipse.recommenders.internal.completion.rcp.subwords.SubwordsUtils;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.rcp.RCPUtils;
import org.eclipse.swt.graphics.TextStyle;

public class SubwordsProposalContext {
    public static final int PREFIX_BONUS = 5000;
    private static StyledString.Styler BIGRAMS_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = JFaceResources.getColorRegistry().get("COUNTER_COLOR");
        }
    };
    private String prefix;
    private final String subwordsMatchingRegion;
    private final IJavaCompletionProposal jdtProposal;
    private final CompletionProposal proposal;
    private final JavaContentAssistInvocationContext ctx;
    private int[] bestSubsequence;
    private int bestSubsequenceScore;

    public SubwordsProposalContext(String prefix, CompletionProposal proposal, IJavaCompletionProposal jdtProposal, JavaContentAssistInvocationContext ctx) {
        this.proposal = proposal;
        this.ctx = ctx;
        this.subwordsMatchingRegion = SubwordsUtils.getTokensBetweenLastWhitespaceAndFirstOpeningBracket(jdtProposal.getDisplayString());
        this.jdtProposal = jdtProposal;
        this.setPrefix(prefix);
    }

    public <T extends IJavaCompletionProposal> T getJdtProposal() {
        return (T)this.jdtProposal;
    }

    public CompletionProposal getProposal() {
        return this.proposal;
    }

    public JavaContentAssistInvocationContext getContext() {
        return this.ctx;
    }

    public void setPrefix(String prefix) {
        this.prefix = (String)Checks.ensureIsNotNull((Object)prefix);
        this.bestSubsequence = LCSS.bestSubsequence(this.subwordsMatchingRegion, prefix);
        this.bestSubsequenceScore = LCSS.scoreSubsequence(this.bestSubsequence);
    }

    public StyledString getStyledDisplayString(StyledString origin) {
        StyledString copy = RCPUtils.deepCopy((StyledString)origin);
        int[] nArray = this.bestSubsequence;
        int n = this.bestSubsequence.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            copy.setStyle(index, 1, BIGRAMS_STYLER);
            ++n2;
        }
        return copy;
    }

    public boolean isPrefixMatch() {
        return this.subwordsMatchingRegion.startsWith(this.prefix);
    }

    public int calculateRelevance() {
        String commonPrefix = StringUtils.getCommonPrefix((String[])new String[]{this.subwordsMatchingRegion.toLowerCase(), this.prefix.toLowerCase()});
        int score = 0;
        if (commonPrefix.length() == this.prefix.length()) {
            score += 200;
        }
        int relevance = this.jdtProposal.getRelevance() + score + this.bestSubsequenceScore;
        return relevance;
    }

    public boolean isRegexMatch() {
        return LCSS.containsSubsequence(this.subwordsMatchingRegion, this.prefix);
    }
}

