/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;

class PasteTaskAction
extends TaskAction {
    public PasteTaskAction(TaskList tasklist, String id) {
        super(tasklist, id);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.paste_task_action_context");
    }

    public void run() {
        MarkerTransfer transfer = MarkerTransfer.getInstance();
        final IMarker[] markerData = (IMarker[])this.getTaskList().getClipboard().getContents((Transfer)transfer);
        if (markerData == null) {
            return;
        }
        final ArrayList newMarkerAttributes = new ArrayList();
        final ArrayList newMarkerResources = new ArrayList();
        try {
            this.getTaskList().getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    int i = 0;
                    while (i < markerData.length) {
                        if (markerData[i].getType().equals("org.eclipse.core.resources.taskmarker")) {
                            newMarkerResources.add(markerData[i].getResource());
                            newMarkerAttributes.add(markerData[i].getAttributes());
                        }
                        ++i;
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)TaskListMessages.PasteTask_errorMessage, null, (IStatus)e.getStatus());
            return;
        }
        Map[] attrs = newMarkerAttributes.toArray(new Map[newMarkerAttributes.size()]);
        IResource[] resources = newMarkerResources.toArray(new IResource[newMarkerResources.size()]);
        final CreateMarkersOperation op = new CreateMarkersOperation("org.eclipse.core.resources.taskmarker", attrs, resources, this.getText());
        this.execute((IUndoableOperation)op, TaskListMessages.PasteTask_errorMessage, null, WorkspaceUndoUtil.getUIInfoAdapter(this.getShell()));
        if (op.getMarkers() != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    TaskList taskList = PasteTaskAction.this.getTaskList();
                    taskList.setSelection((ISelection)new StructuredSelection((Object[])op.getMarkers()), true);
                }
            });
        }
    }
}

