/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.util;

import java.util.LinkedList;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;

public class ParentGatherer {
    final MavenProject mavenProject;
    final IMavenProjectFacade projectFacade;

    public ParentGatherer(MavenProject leafProject, IMavenProjectFacade facade) {
        this.mavenProject = leafProject;
        this.projectFacade = facade;
    }

    public LinkedList<MavenProject> getParentHierarchy(IProgressMonitor monitor) throws CoreException {
        final LinkedList<MavenProject> hierarchy = new LinkedList<MavenProject>();
        final IMaven maven = MavenPlugin.getMaven();
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        maven.detachFromSession(this.mavenProject);
        hierarchy.add(this.mavenProject);
        projectManager.execute(this.projectFacade, (ICallable)new ICallable<Void>(){

            public Void call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                MavenProject project = ParentGatherer.this.mavenProject;
                while (project.getModel().getParent() != null) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    project = maven.resolveParentProject(project, monitor);
                    hierarchy.add(project);
                }
                return null;
            }
        }, monitor);
        return hierarchy;
    }
}

