/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.utils.codestructs;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public class Variable
implements Comparable<Variable> {
    private IMethodName referenceContext;
    private String name;
    public ITypeName type;

    public static Variable create(String name, ITypeName variableType, IMethodName declaringMethod) {
        Variable res = new Variable();
        res.name = name;
        res.type = variableType;
        res.referenceContext = declaringMethod;
        return res;
    }

    protected Variable() {
    }

    public ITypeName getType() {
        return this.type;
    }

    public String getNameLiteral() {
        return this.name;
    }

    public IMethodName getReferenceContext() {
        return this.referenceContext;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, Collections.singleton("type"));
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, Collections.singleton("type"));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public int compareTo(Variable other) {
        return CompareToBuilder.reflectionCompare((Object)this, (Object)other, (Collection)Lists.newArrayList((Object[])new String[]{"type", "pointsTo"}));
    }

    public boolean isThis() {
        return "this".equals(this.name);
    }
}

