/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.gson;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.gson.GsonFieldNameDeserializer;
import org.eclipse.recommenders.utils.gson.GsonFileDeserializer;
import org.eclipse.recommenders.utils.gson.GsonFileSerializer;
import org.eclipse.recommenders.utils.gson.GsonMethodNameDeserializer;
import org.eclipse.recommenders.utils.gson.GsonNameSerializer;
import org.eclipse.recommenders.utils.gson.GsonTypeNameDeserializer;
import org.eclipse.recommenders.utils.gson.ISO8601DateParser;
import org.eclipse.recommenders.utils.gson.MultimapTypeAdapter;
import org.eclipse.recommenders.utils.names.IFieldName;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmFieldName;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.names.VmTypeName;

public class GsonUtil {
    public static final Type T_LIST_STRING = new TypeToken<List<String>>(){}.getType();
    private static Gson gson;

    public static synchronized Gson getInstance() {
        if (gson == null) {
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapter(VmMethodName.class, (Object)new GsonNameSerializer());
            builder.registerTypeAdapter(IMethodName.class, (Object)new GsonNameSerializer());
            builder.registerTypeAdapter(VmMethodName.class, (Object)new GsonMethodNameDeserializer());
            builder.registerTypeAdapter(IMethodName.class, (Object)new GsonMethodNameDeserializer());
            builder.registerTypeAdapter(VmTypeName.class, (Object)new GsonNameSerializer());
            builder.registerTypeAdapter(ITypeName.class, (Object)new GsonNameSerializer());
            builder.registerTypeAdapter(VmTypeName.class, (Object)new GsonTypeNameDeserializer());
            builder.registerTypeAdapter(ITypeName.class, (Object)new GsonTypeNameDeserializer());
            builder.registerTypeAdapter(VmFieldName.class, (Object)new GsonNameSerializer());
            builder.registerTypeAdapter(IFieldName.class, (Object)new GsonNameSerializer());
            builder.registerTypeAdapter(VmFieldName.class, (Object)new GsonFieldNameDeserializer());
            builder.registerTypeAdapter(IFieldName.class, (Object)new GsonFieldNameDeserializer());
            builder.registerTypeAdapter(File.class, (Object)new GsonFileDeserializer());
            builder.registerTypeAdapter(File.class, (Object)new GsonFileSerializer());
            builder.setPrettyPrinting();
            builder.registerTypeAdapter(Date.class, (Object)new ISO8601DateParser());
            builder.registerTypeAdapter(Multimap.class, (Object)new MultimapTypeAdapter());
            builder.enableComplexMapKeySerialization();
            gson = builder.create();
        }
        return gson;
    }

    public static <T> T deserialize(CharSequence json, Type classOfT) {
        return GsonUtil.deserialize(json.toString(), classOfT);
    }

    public static <T> T deserialize(String json, Type classOfT) {
        Checks.ensureIsNotNull(json);
        Checks.ensureIsNotNull(classOfT);
        try {
            return (T)GsonUtil.getInstance().fromJson(json, classOfT);
        }
        catch (Exception e) {
            throw Throws.throwUnhandledException(e);
        }
    }

    public static <T> T deserialize(InputStream jsonStream, Type classOfT) {
        Object object;
        Checks.ensureIsNotNull(jsonStream);
        Checks.ensureIsNotNull(classOfT);
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(jsonStream, "UTF-8");
            object = GsonUtil.getInstance().fromJson((Reader)reader, classOfT);
        }
        catch (Exception e) {
            try {
                throw Throws.throwUnhandledException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        return (T)object;
    }

    public static <T> T deserialize(File jsonFile, Type classOfT) {
        T t;
        Checks.ensureIsNotNull(jsonFile);
        Checks.ensureIsNotNull(classOfT);
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(jsonFile));
            t = GsonUtil.deserialize(in, classOfT);
        }
        catch (Exception e) {
            try {
                throw Throws.throwUnhandledException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        return t;
    }

    public static String serialize(Object obj) {
        Checks.ensureIsNotNull(obj);
        StringBuilder sb = new StringBuilder();
        GsonUtil.serialize(obj, sb);
        return sb.toString();
    }

    public static void serialize(Object obj, Appendable writer) {
        Checks.ensureIsNotNull(obj);
        Checks.ensureIsNotNull(writer);
        try {
            GsonUtil.getInstance().toJson(obj, writer);
        }
        catch (Exception e) {
            throw Throws.throwUnhandledException(e);
        }
    }

    public static void serialize(Object obj, File jsonFile) {
        Checks.ensureIsNotNull(obj);
        Checks.ensureIsNotNull(jsonFile);
        BufferedOutputStream out = null;
        try {
            try {
                out = new BufferedOutputStream(new FileOutputStream(jsonFile));
                GsonUtil.serialize(obj, out);
            }
            catch (Exception e) {
                throw Throws.throwUnhandledException(e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly(out);
    }

    public static void serialize(Object obj, OutputStream out) {
        Checks.ensureIsNotNull(obj);
        Checks.ensureIsNotNull(out);
        OutputStreamWriter writer = null;
        try {
            try {
                writer = new OutputStreamWriter(out, "UTF-8");
                GsonUtil.getInstance().toJson(obj, (Appendable)writer);
            }
            catch (Exception e) {
                throw Throws.throwUnhandledException(e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly(writer);
    }

    public static <T> List<T> deserializeZip(File zip, Class<T> classOfT) throws IOException {
        LinkedList res = Lists.newLinkedList();
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            InputSupplier fis = Files.newInputStreamSupplier((File)zip);
            zis = new ZipInputStream((InputStream)fis.getInput());
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                res.add(GsonUtil.deserialize(zis, classOfT));
            }
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(zis);
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)zis);
        return res;
    }
}

