/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import org.apache.commons.collections.primitives.DoubleCollection;
import org.apache.commons.collections.primitives.DoubleIterator;

public abstract class AbstractDoubleCollection
implements DoubleCollection {
    @Override
    public abstract DoubleIterator iterator();

    @Override
    public abstract int size();

    protected AbstractDoubleCollection() {
    }

    @Override
    public boolean add(double element) {
        throw new UnsupportedOperationException("add(double) is not supported.");
    }

    @Override
    public boolean addAll(DoubleCollection c) {
        boolean modified = false;
        DoubleIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= this.add(iter.next());
        }
        return modified;
    }

    @Override
    public void clear() {
        DoubleIterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public boolean contains(double element) {
        DoubleIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != element) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(DoubleCollection c) {
        DoubleIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean removeElement(double element) {
        DoubleIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != element) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(DoubleCollection c) {
        boolean modified = false;
        DoubleIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= this.removeElement(iter.next());
        }
        return modified;
    }

    @Override
    public boolean retainAll(DoubleCollection c) {
        boolean modified = false;
        DoubleIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (c.contains(iter.next())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public double[] toArray() {
        double[] array = new double[this.size()];
        int i = 0;
        DoubleIterator iter = this.iterator();
        while (iter.hasNext()) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }

    @Override
    public double[] toArray(double[] a) {
        if (a.length < this.size()) {
            return this.toArray();
        }
        int i = 0;
        DoubleIterator iter = this.iterator();
        while (iter.hasNext()) {
            a[i] = iter.next();
            ++i;
        }
        return a;
    }
}

