/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.overrides;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContextFactory;
import org.eclipse.recommenders.internal.completion.rcp.overrides.OverridesRecommendation;
import org.eclipse.recommenders.internal.completion.rcp.overrides.OverridesRecommender;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.eclipse.recommenders.utils.rcp.CompletionProposalDecorator;

public class OverridesCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private IRecommendersCompletionContext ctx;
    private List<OverridesRecommendation> recommendations = Collections.emptyList();
    private List<IJavaCompletionProposal> proposals;
    private OverridesRecommender recommender;
    private IRecommendersCompletionContextFactory contextFactory;

    @Inject
    public OverridesCompletionProposalComputer(OverridesRecommender recommender, IRecommendersCompletionContextFactory contextFactory) {
        this.recommender = recommender;
        this.contextFactory = contextFactory;
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        this.proposals = Lists.newLinkedList();
        if (context instanceof JavaContentAssistInvocationContext) {
            try {
                JavaContentAssistInvocationContext jdtContext = (JavaContentAssistInvocationContext)context;
                this.ctx = this.contextFactory.create(jdtContext);
                this.recommender.startSession(this.ctx);
                this.recommendations = this.recommender.getRecommendations();
                this.computeProposals();
            }
            catch (CoreException e) {
                RecommendersPlugin.log((CoreException)e);
            }
        }
        return this.proposals;
    }

    private void computeProposals() {
        String prefix = this.ctx.getPrefix();
        block3: for (Map.Entry pair : this.ctx.getProposals().entrySet()) {
            IJavaCompletionProposal uiProposal = (IJavaCompletionProposal)pair.getKey();
            CompletionProposal cProposal = (CompletionProposal)pair.getValue();
            switch (cProposal.getKind()) {
                case 7: {
                    String signature = String.valueOf(cProposal.getSignature()).replace('.', '/');
                    String name = String.valueOf(cProposal.getName());
                    String propSignature = (String.valueOf(name) + signature).replaceAll("<\\.>", "");
                    for (OverridesRecommendation r : this.recommendations) {
                        String recSignature;
                        if (!r.method.getName().startsWith(prefix) || !(recSignature = r.method.getSignature()).equals(propSignature)) continue;
                        if (uiProposal instanceof AbstractJavaCompletionProposal) {
                            int baseRelevance = uiProposal.getRelevance();
                            ((AbstractJavaCompletionProposal)uiProposal).setRelevance(baseRelevance += (int)Math.rint(r.probability * 100.0));
                        }
                        CompletionProposalDecorator decoratedProposal = new CompletionProposalDecorator(uiProposal, r.probability);
                        this.proposals.add((IJavaCompletionProposal)decoratedProposal);
                    }
                    continue block3;
                }
            }
        }
    }

    public void sessionStarted() {
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }
}

