/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.overrides;

import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IType;
import org.eclipse.recommenders.internal.completion.rcp.overrides.ClassOverridesNetwork;
import org.eclipse.recommenders.internal.completion.rcp.overrides.ManualModelStoreWiring;
import org.eclipse.recommenders.internal.completion.rcp.overrides.OverridesCompletionProposalComputer;
import org.eclipse.recommenders.internal.rcp.models.IModelArchiveStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class OverridesModule
extends AbstractModule {
    public static final String MODEL_VERSION = "0.1";
    public static TypeLiteral<IModelArchiveStore<IType, ClassOverridesNetwork>> STORE = new TypeLiteral<IModelArchiveStore<IType, ClassOverridesNetwork>>(){};

    protected void configure() {
        this.bindCompletionEngine();
    }

    private void bindCompletionEngine() {
        this.bind(OverridesCompletionProposalComputer.class).in(Scopes.SINGLETON);
        IPath stateLocation = Platform.getStateLocation((Bundle)FrameworkUtil.getBundle(((Object)((Object)this)).getClass()));
        File index = new File(stateLocation.toFile(), String.format("ovrm-models-%s.json", MODEL_VERSION));
        this.bind(File.class).annotatedWith(OverridesModelStore.class).toInstance((Object)index);
        this.bind(STORE).to(ManualModelStoreWiring.OverridesModelArchiveStore.class).in(Scopes.SINGLETON);
    }

    @BindingAnnotation
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface OverridesModelStore {
    }
}

