/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.archive;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarFormat
implements ArchiveCommand.Format<ArchiveOutputStream> {
    private static final List<String> SUFFIXES = Collections.unmodifiableList(Arrays.asList(".tar"));

    public ArchiveOutputStream createArchiveOutputStream(OutputStream s) {
        TarArchiveOutputStream out = new TarArchiveOutputStream(s, "UTF-8");
        out.setLongFileMode(3);
        out.setBigNumberMode(2);
        return out;
    }

    public void putEntry(ArchiveOutputStream out, String path, FileMode mode, ObjectLoader loader) throws IOException {
        if (mode == FileMode.SYMLINK) {
            TarArchiveEntry entry = new TarArchiveEntry(path, 50);
            entry.setLinkName(new String(loader.getCachedBytes(100), "UTF-8"));
            out.putArchiveEntry((ArchiveEntry)entry);
            out.closeArchiveEntry();
            return;
        }
        TarArchiveEntry entry = new TarArchiveEntry(path);
        if (mode == FileMode.REGULAR_FILE || mode == FileMode.EXECUTABLE_FILE) {
            entry.setMode(mode.getBits());
        }
        entry.setSize(loader.getSize());
        out.putArchiveEntry((ArchiveEntry)entry);
        loader.copyTo((OutputStream)out);
        out.closeArchiveEntry();
    }

    public Iterable<String> suffixes() {
        return SUFFIXES;
    }
}

