/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.NullAnnotationsFix;
import org.eclipse.jdt.internal.corext.fix.NullAnnotationsRewriteOperations;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.fix.NullAnnotationsCleanUp;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ExtractToNullCheckedLocalProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.FixCorrectionProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullAnnotationsCorrectionProcessor {
    public static void addReturnAndArgumentTypeProposal(IInvocationContext context, IProblemLocation problem, NullAnnotationsRewriteOperations.ChangeKind changeKind, Collection<ICommandAccess> proposals) {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        boolean isArgumentProblem = NullAnnotationsFix.isComplainingAboutArgument(selectedNode);
        if (isArgumentProblem || NullAnnotationsFix.isComplainingAboutReturn(selectedNode)) {
            NullAnnotationsCorrectionProcessor.addNullAnnotationInSignatureProposal(context, problem, proposals, changeKind, isArgumentProblem);
        }
    }

    public static void addNullAnnotationInSignatureProposal(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals, NullAnnotationsRewriteOperations.ChangeKind changeKind, boolean isArgumentProblem) {
        NullAnnotationsFix fix = NullAnnotationsFix.createNullAnnotationInSignatureFix(context.getASTRoot(), problem, changeKind, isArgumentProblem);
        if (fix != null) {
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            Hashtable<String, String> options = new Hashtable<String, String>();
            if (fix.getCu() != context.getASTRoot()) {
                final CompilationUnit cu = fix.getCu();
                final IInvocationContext originalContext = context;
                context = new IInvocationContext(){

                    public int getSelectionOffset() {
                        return originalContext.getSelectionOffset();
                    }

                    public int getSelectionLength() {
                        return originalContext.getSelectionLength();
                    }

                    public ASTNode getCoveringNode() {
                        return originalContext.getCoveringNode();
                    }

                    public ASTNode getCoveredNode() {
                        return originalContext.getCoveredNode();
                    }

                    public ICompilationUnit getCompilationUnit() {
                        return (ICompilationUnit)cu.getJavaElement();
                    }

                    public CompilationUnit getASTRoot() {
                        return cu;
                    }
                };
            }
            int relevance = changeKind == NullAnnotationsRewriteOperations.ChangeKind.OVERRIDDEN ? 9 : 10;
            FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new NullAnnotationsCleanUp(options, problem.getProblemId()), relevance, image, context);
            proposals.add(proposal);
        }
    }

    public static void addRemoveRedundantAnnotationProposal(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        NullAnnotationsFix fix = NullAnnotationsFix.createRemoveRedundantNullAnnotationsFix(context.getASTRoot(), problem);
        if (fix == null) {
            return;
        }
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        Hashtable<String, String> options = new Hashtable<String, String>();
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new NullAnnotationsCleanUp(options, problem.getProblemId()), 5, image, context);
        proposals.add(proposal);
    }

    public static void addExtractCheckedLocalProposal(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        CompilationUnit compilationUnit = context.getASTRoot();
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        SimpleName name = NullAnnotationsCorrectionProcessor.findProblemFieldName(selectedNode, problem.getProblemId());
        if (name == null) {
            return;
        }
        ASTNode method = ASTNodes.getParent(selectedNode, MethodDeclaration.class);
        if (method == null) {
            method = ASTNodes.getParent(selectedNode, Initializer.class);
        }
        if (method == null) {
            return;
        }
        proposals.add(new ExtractToNullCheckedLocalProposal(cu, compilationUnit, name, method));
    }

    private static SimpleName findProblemFieldName(ASTNode selectedNode, int problemID) {
        if (selectedNode instanceof FieldAccess) {
            selectedNode = ((FieldAccess)selectedNode).getName();
        } else if (selectedNode instanceof QualifiedName) {
            selectedNode = ((QualifiedName)selectedNode).getName();
        }
        if (selectedNode instanceof SimpleName) {
            SimpleName name = (SimpleName)selectedNode;
            if (problemID == 33555356) {
                return name;
            }
            IBinding binding = name.resolveBinding();
            if (binding instanceof IVariableBinding && ((IVariableBinding)binding).isField()) {
                return name;
            }
        }
        return null;
    }
}

