/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.io.Serializable;
import java.util.ArrayList;
import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.ast.BlockNode;
import org.mvel2.ast.NestedStatement;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ParseTools;
import org.mvel2.util.PropertyTools;
import org.mvel2.util.StringAppender;

public class WithNode
extends BlockNode
implements NestedStatement {
    protected String nestParm;
    protected ExecutableStatement nestedStatement;
    protected ParmValuePair[] withExpressions;

    public WithNode(char[] expr, char[] block, int fields, ParserContext pCtx) {
        super(pCtx);
        this.name = expr;
        this.nestParm = ParseTools.createStringTrimmed(expr);
        this.block = block;
        if ((fields & 0x10) != 0) {
            pCtx.setBlockSymbols(true);
            this.nestedStatement = (ExecutableStatement)ParseTools.subCompileExpression(this.nestParm.toCharArray(), pCtx);
            this.egressType = this.nestedStatement.getKnownEgressType();
            this.withExpressions = WithNode.compileWithExpressions(block, this.nestParm, this.egressType, pCtx);
            pCtx.setBlockSymbols(false);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        Object ctxObject = this.nestedStatement.getValue(ctx, thisValue, factory);
        if (ctxObject == null) {
            throw new CompileException("with-block against null pointer");
        }
        ParmValuePair[] parmValuePairArray = this.withExpressions;
        int n = this.withExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            ParmValuePair pvp = parmValuePairArray[n2];
            pvp.eval(ctxObject, factory);
            ++n2;
        }
        return ctxObject;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ctx = MVEL.eval(this.name, ctx, factory);
        ParseTools.parseWithExpressions(this.nestParm, this.block, 0, this.block.length, ctx, factory);
        return ctx;
    }

    public static ParmValuePair[] compileWithExpressions(char[] block, String nestParm, Class egressType, ParserContext pCtx) {
        ArrayList<ParmValuePair> parms = new ArrayList<ParmValuePair>();
        String parm = "";
        int start = 0;
        int end = -1;
        int oper = -1;
        int i = 0;
        while (i < block.length) {
            switch (block[i]) {
                case '(': 
                case '[': 
                case '{': {
                    i = ParseTools.balancedCapture(block, i, block[i]);
                    break;
                }
                case '/': {
                    if (i < block.length && block[i + 1] == '/') {
                        while (i < block.length && block[i] != '\n') {
                            block[i++] = 32;
                        }
                        if (parm != null) break;
                        start = i;
                        break;
                    }
                    if (i < block.length && block[i + 1] == '*') {
                        int len = block.length - 1;
                        while (i < len && (block[i] != '*' || block[i + 1] != '/')) {
                            block[i++] = 32;
                        }
                        block[i++] = 32;
                        block[i++] = 32;
                        if (parm != null) break;
                        start = i;
                        break;
                    }
                    if (i >= block.length || block[i + 1] != '=') break;
                    oper = 3;
                    break;
                }
                case '%': 
                case '*': 
                case '+': 
                case '-': {
                    if (i + 1 >= block.length || block[i + 1] != '=') break;
                    oper = ParseTools.opLookup(block[i]);
                    break;
                }
                case '=': {
                    parm = ParseTools.createStringTrimmed(block, start, i - start - (oper != -1 ? 1 : 0));
                    start = i + 1;
                    break;
                }
                case ',': {
                    if (end == -1) {
                        end = i;
                    }
                    if (parm == null || parm.length() == 0) {
                        parms.add(new ParmValuePair(null, (ExecutableStatement)ParseTools.subCompileExpression(new StringAppender(nestParm).append('.').append(ParseTools.subset(block, start, end - start)).toChars(), pCtx), egressType, pCtx));
                        oper = -1;
                        start = ++i;
                    } else {
                        parms.add(new ParmValuePair(parm, (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.createShortFormOperativeAssignment(String.valueOf(nestParm) + "." + parm, ParseTools.subset(block, start, end - start), oper), pCtx), egressType, pCtx));
                        parm = null;
                        oper = -1;
                        start = ++i;
                    }
                    end = -1;
                }
            }
            ++i;
        }
        end = block.length;
        if (start != end) {
            if (parm == null || "".equals(parm)) {
                parms.add(new ParmValuePair(null, (ExecutableStatement)ParseTools.subCompileExpression(new StringAppender(nestParm).append('.').append(ParseTools.subset(block, start, end - start)).toChars(), pCtx), egressType, pCtx));
            } else {
                parms.add(new ParmValuePair(parm, (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.createShortFormOperativeAssignment(String.valueOf(nestParm) + "." + parm, ParseTools.subset(block, start, end - start), oper), pCtx), egressType, pCtx));
            }
        }
        ParmValuePair[] withExpressions = new ParmValuePair[parms.size()];
        parms.toArray(withExpressions);
        return withExpressions;
    }

    public ExecutableStatement getNestedStatement() {
        return this.nestedStatement;
    }

    public ParmValuePair[] getWithExpressions() {
        return this.withExpressions;
    }

    public static final class ParmValuePair
    implements Serializable {
        private Serializable setExpression;
        private ExecutableStatement statement;

        public ParmValuePair() {
        }

        public ParmValuePair(String parameter, ExecutableStatement statement, Class ingressType, ParserContext pCtx) {
            if (parameter != null && parameter.length() != 0) {
                this.setExpression = MVEL.compileSetExpression(parameter, ingressType != null ? PropertyTools.getReturnType(ingressType, parameter, pCtx) : Object.class, pCtx);
            }
            this.statement = statement;
        }

        public Serializable getSetExpression() {
            return this.setExpression;
        }

        public void setSetExpression(Serializable setExpression) {
            this.setExpression = setExpression;
        }

        public ExecutableStatement getStatement() {
            return this.statement;
        }

        public void setStatement(ExecutableStatement statement) {
            this.statement = statement;
        }

        public void eval(Object ctx, VariableResolverFactory factory) {
            if (this.setExpression == null) {
                this.statement.getValue(ctx, factory);
            } else {
                MVEL.executeSetExpression(this.setExpression, ctx, factory, this.statement.getValue(ctx, factory));
            }
        }
    }
}

