/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.integration.impl;

import java.util.HashSet;
import java.util.Set;
import org.mvel2.UnresolveablePropertyException;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.BaseVariableResolverFactory;
import org.mvel2.integration.impl.IndexVariableResolver;
import org.mvel2.integration.impl.MapVariableResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedVariableResolverFactory
extends BaseVariableResolverFactory {
    private Object[] values;

    public IndexedVariableResolverFactory(String[] varNames, Object[] values) {
        this.indexedVariableNames = varNames;
        this.values = values;
        this.indexedVariableResolvers = IndexedVariableResolverFactory.createResolvers(values);
    }

    public IndexedVariableResolverFactory(String[] varNames, Object[] values, VariableResolverFactory nextFactory) {
        this.indexedVariableNames = varNames;
        this.values = values;
        this.nextFactory = new MapVariableResolverFactory();
        this.nextFactory.setNextFactory(nextFactory);
        this.indexedVariableResolvers = IndexedVariableResolverFactory.createResolvers(values);
    }

    private static VariableResolver[] createResolvers(Object[] values) {
        VariableResolver[] vr = new VariableResolver[values.length];
        int i = 0;
        while (i < values.length) {
            vr[i] = new IndexVariableResolver(i, values);
            ++i;
        }
        return vr;
    }

    @Override
    public VariableResolver createIndexedVariable(int index, String name, Object value) {
        throw new RuntimeException("Error: cannot write to factory");
    }

    @Override
    public VariableResolver getIndexedVariableResolver(int index) {
        return this.indexedVariableResolvers[index];
    }

    @Override
    public VariableResolver createVariable(String name, Object value) {
        return this.nextFactory.createVariable(name, value);
    }

    @Override
    public VariableResolver createVariable(String name, Object value, Class<?> type) {
        if (this.nextFactory == null) {
            this.nextFactory = new MapVariableResolverFactory();
        }
        return this.nextFactory.createVariable(name, value, type);
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        VariableResolver vr = this.getResolver(name);
        if (vr != null) {
            return vr;
        }
        if (this.nextFactory != null) {
            return this.nextFactory.getVariableResolver(name);
        }
        throw new UnresolveablePropertyException("unable to resolve variable '" + name + "'");
    }

    @Override
    public boolean isResolveable(String name) {
        return this.isTarget(name) || this.nextFactory != null && this.nextFactory.isResolveable(name);
    }

    protected VariableResolver addResolver(String name, VariableResolver vr) {
        this.variableResolvers.put(name, vr);
        return vr;
    }

    private VariableResolver getResolver(String name) {
        int i = 0;
        while (i < this.indexedVariableNames.length) {
            if (this.indexedVariableNames[i].equals(name)) {
                return this.indexedVariableResolvers[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isTarget(String name) {
        int i = 0;
        while (i < this.indexedVariableNames.length) {
            if (this.indexedVariableNames[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Set<String> getKnownVariables() {
        return new HashSet<String>(0);
    }

    public void clear() {
    }

    @Override
    public boolean isIndexedFactory() {
        return true;
    }
}

