/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.decorators;

import org.apache.commons.collections.primitives.DoubleListIterator;
import org.apache.commons.collections.primitives.decorators.ProxyDoubleListIterator;

public final class UnmodifiableDoubleListIterator
extends ProxyDoubleListIterator {
    private DoubleListIterator proxied = null;

    UnmodifiableDoubleListIterator(DoubleListIterator iterator) {
        this.proxied = iterator;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This DoubleListIterator is not modifiable.");
    }

    @Override
    public void add(double value) {
        throw new UnsupportedOperationException("This DoubleListIterator is not modifiable.");
    }

    @Override
    public void set(double value) {
        throw new UnsupportedOperationException("This DoubleListIterator is not modifiable.");
    }

    @Override
    protected DoubleListIterator getListIterator() {
        return this.proxied;
    }

    public static final DoubleListIterator wrap(DoubleListIterator iterator) {
        if (iterator == null) {
            return null;
        }
        if (iterator instanceof UnmodifiableDoubleListIterator) {
            return iterator;
        }
        return new UnmodifiableDoubleListIterator(iterator);
    }
}

