/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.calls.engine;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.recommenders.internal.utils.codestructs.Variable;
import org.eclipse.recommenders.rcp.IRecommendation;
import org.eclipse.recommenders.utils.names.IMethodName;

public class CallsRecommendation
implements IRecommendation,
Comparable<CallsRecommendation> {
    public Variable local;
    public IMethodName method;
    public double probability;

    public static CallsRecommendation create(Variable local, IMethodName recommendedMethodCall, double methodCallProbability) {
        CallsRecommendation res = new CallsRecommendation();
        res.local = local;
        res.method = recommendedMethodCall;
        res.probability = methodCallProbability;
        return res;
    }

    @Override
    public int compareTo(CallsRecommendation other) {
        int probabilityCmp = Double.compare(other.probability, this.probability);
        return probabilityCmp != 0 ? probabilityCmp : this.method.compareTo((Object)other.method);
    }

    public double getProbability() {
        return this.probability;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

