/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.calls.wiring;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jdt.core.IType;
import org.eclipse.recommenders.internal.completion.rcp.calls.engine.CallNetZipModelFactory;
import org.eclipse.recommenders.internal.completion.rcp.calls.net.IObjectMethodCallsNet;
import org.eclipse.recommenders.internal.completion.rcp.calls.wiring.CallsCompletionModule;
import org.eclipse.recommenders.internal.rcp.models.IModelArchive;
import org.eclipse.recommenders.internal.rcp.models.ModelArchiveMetadata;
import org.eclipse.recommenders.internal.rcp.models.archive.IModelFactory;
import org.eclipse.recommenders.internal.rcp.models.archive.PoolingModelArchive;
import org.eclipse.recommenders.internal.rcp.models.store.DefaultModelArchiveStore;
import org.eclipse.recommenders.internal.rcp.models.store.IDependenciesFactory;
import org.eclipse.recommenders.internal.rcp.models.store.ModelArchiveResolutionJob;
import org.eclipse.recommenders.rcp.IClasspathEntryInfoProvider;
import org.eclipse.recommenders.rcp.repo.IModelRepository;
import org.eclipse.recommenders.rcp.repo.IModelRepositoryIndex;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;

public class ManualModelStoreWiring {

    static class CallModelArchiveStore
    extends DefaultModelArchiveStore<IType, IObjectMethodCallsNet> {
        @Inject
        public CallModelArchiveStore(@CallsCompletionModule.CallCompletion File store, final IModelRepository repository, final IModelRepositoryIndex searchindex, final IClasspathEntryInfoProvider cpeInfoProvider, final JavaElementResolver jdtResolver) {
            super(store, "call", repository, new IDependenciesFactory(){

                public ModelArchiveResolutionJob newResolutionJob(ModelArchiveMetadata metadata, String classifier) {
                    return new ModelArchiveResolutionJob(metadata, cpeInfoProvider, repository, searchindex, "call");
                }

                public IModelArchive<IType, IObjectMethodCallsNet> newModelArchive(File location) throws IOException {
                    if (!location.exists()) {
                        throw new FileNotFoundException("Model file not found: " + location.getAbsolutePath());
                    }
                    return new PoolingModelArchive((IModelFactory)new CallNetZipModelFactory(location, jdtResolver));
                }
            });
        }
    }
}

