/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.ClassServiceFactory;
import org.eclipse.jdt.apt.core.internal.FactoryPluginManager;
import org.eclipse.jdt.apt.core.internal.IServiceFactory;
import org.eclipse.jdt.apt.core.internal.JarClassLoader;
import org.eclipse.jdt.apt.core.internal.JarFactoryContainer;
import org.eclipse.jdt.apt.core.internal.LoadFailureHandler;
import org.eclipse.jdt.apt.core.internal.Messages;
import org.eclipse.jdt.apt.core.internal.util.FactoryContainer;
import org.eclipse.jdt.apt.core.internal.util.FactoryPath;
import org.eclipse.jdt.apt.core.internal.util.FactoryPathUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessorFactoryLoader {
    private static AnnotationProcessorFactoryLoader LOADER;
    private static final String JAR_EXTENSION = "jar";
    private final Map<IJavaProject, Map<AnnotationProcessorFactory, FactoryPath.Attributes>> _project2Java5Factories = new HashMap<IJavaProject, Map<AnnotationProcessorFactory, FactoryPath.Attributes>>();
    private final Map<IJavaProject, Map<IServiceFactory, FactoryPath.Attributes>> _project2Java6Factories = new HashMap<IJavaProject, Map<IServiceFactory, FactoryPath.Attributes>>();
    private final Map<IJavaProject, ClassLoader> _iterativeLoaders = new HashMap<IJavaProject, ClassLoader>();
    private final Map<IJavaProject, ClassLoader> _batchLoaders = new HashMap<IJavaProject, ClassLoader>();
    private final Map<String, Set<IJavaProject>> _container2Project = new HashMap<String, Set<IJavaProject>>();

    public static synchronized AnnotationProcessorFactoryLoader getLoader() {
        if (LOADER == null) {
            LOADER = new AnnotationProcessorFactoryLoader();
            LOADER.registerListener();
        }
        return LOADER;
    }

    private void registerListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ResourceListener(), 12);
    }

    public synchronized void resetAll() {
        this.removeAptBuildProblemMarkers(null);
        this._project2Java5Factories.clear();
        this._project2Java6Factories.clear();
        for (ClassLoader cl : this._iterativeLoaders.values()) {
            if (!(cl instanceof JarClassLoader)) continue;
            ((JarClassLoader)cl).close();
        }
        this._iterativeLoaders.clear();
        this._container2Project.clear();
        for (ClassLoader cl : this._batchLoaders.values()) {
            if (!(cl instanceof JarClassLoader)) continue;
            ((JarClassLoader)cl).close();
        }
        this._batchLoaders.clear();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            this.verifyFactoryPath(JavaCore.create((IProject)proj));
            ++n2;
        }
    }

    public synchronized void resetBatchProcessors(IJavaProject javaProj) {
        ClassLoader c;
        Collection<FactoryPath.Attributes> attrs = null;
        Map<AnnotationProcessorFactory, FactoryPath.Attributes> factories = this._project2Java5Factories.get(javaProj);
        if (factories != null) {
            attrs = factories.values();
        } else {
            Map<IServiceFactory, FactoryPath.Attributes> java6factories = this._project2Java6Factories.get(javaProj);
            if (java6factories != null) {
                attrs = java6factories.values();
            } else {
                return;
            }
        }
        boolean batchProcsFound = false;
        for (FactoryPath.Attributes attr : attrs) {
            if (!attr.runInBatchMode()) continue;
            batchProcsFound = true;
            break;
        }
        if (batchProcsFound) {
            this._project2Java5Factories.remove(javaProj);
            this._project2Java6Factories.remove(javaProj);
        }
        if ((c = this._batchLoaders.remove(javaProj)) instanceof JarClassLoader) {
            ((JarClassLoader)c).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<AnnotationProcessorFactory, FactoryPath.Attributes> getJava5FactoriesAndAttributesForProject(IJavaProject jproj) {
        LoadFailureHandler failureHandler = new LoadFailureHandler(jproj);
        AnnotationProcessorFactoryLoader annotationProcessorFactoryLoader = this;
        synchronized (annotationProcessorFactoryLoader) {
            Map<AnnotationProcessorFactory, FactoryPath.Attributes> factories = this._project2Java5Factories.get(jproj);
            if (factories != null) {
                return Collections.unmodifiableMap(factories);
            }
            FactoryPath fp = FactoryPathUtil.getFactoryPath(jproj);
            Map<FactoryContainer, FactoryPath.Attributes> containers = fp.getEnabledContainers();
            this.loadFactories(containers, jproj, failureHandler);
        }
        failureHandler.reportFailureMarkers();
        return Collections.unmodifiableMap(this._project2Java5Factories.get(jproj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<IServiceFactory, FactoryPath.Attributes> getJava6FactoriesAndAttributesForProject(IJavaProject jproj) {
        LoadFailureHandler failureHandler = new LoadFailureHandler(jproj);
        AnnotationProcessorFactoryLoader annotationProcessorFactoryLoader = this;
        synchronized (annotationProcessorFactoryLoader) {
            Map<IServiceFactory, FactoryPath.Attributes> factories = this._project2Java6Factories.get(jproj);
            if (factories != null) {
                return Collections.unmodifiableMap(factories);
            }
            FactoryPath fp = FactoryPathUtil.getFactoryPath(jproj);
            Map<FactoryContainer, FactoryPath.Attributes> containers = fp.getEnabledContainers();
            this.loadFactories(containers, jproj, failureHandler);
        }
        failureHandler.reportFailureMarkers();
        return Collections.unmodifiableMap(this._project2Java6Factories.get(jproj));
    }

    public synchronized List<AnnotationProcessorFactory> getJava5FactoriesForProject(IJavaProject jproj) {
        Map<AnnotationProcessorFactory, FactoryPath.Attributes> factoriesAndAttrs = this.getJava5FactoriesAndAttributesForProject(jproj);
        ArrayList<AnnotationProcessorFactory> factories = new ArrayList<AnnotationProcessorFactory>(factoriesAndAttrs.keySet());
        return Collections.unmodifiableList(factories);
    }

    private void addToResourcesMap(String key, IJavaProject jproj) {
        Set<IJavaProject> s = this._container2Project.get(key);
        if (s == null) {
            s = new HashSet<IJavaProject>();
            this._container2Project.put(key, s);
        }
        s.add(jproj);
    }

    private Object loadInstance(String factoryName, ClassLoader cl, IJavaProject jproj, LoadFailureHandler failureHandler) {
        Object f = null;
        try {
            Class<?> c = cl.loadClass(factoryName);
            f = c.newInstance();
        }
        catch (Exception e) {
            AptPlugin.trace("Failed to load factory " + factoryName, e);
            failureHandler.addFailedFactory(factoryName);
        }
        catch (NoClassDefFoundError ncdfe) {
            AptPlugin.trace("Failed to load " + factoryName, ncdfe);
            failureHandler.addFailedFactory(factoryName);
        }
        return f;
    }

    private void loadFactories(Map<FactoryContainer, FactoryPath.Attributes> containers, IJavaProject project, LoadFailureHandler failureHandler) {
        ClassLoader iterativeClassLoader;
        LinkedHashMap<AnnotationProcessorFactory, FactoryPath.Attributes> java5Factories = new LinkedHashMap<AnnotationProcessorFactory, FactoryPath.Attributes>();
        LinkedHashMap<IServiceFactory, FactoryPath.Attributes> java6Factories = new LinkedHashMap<IServiceFactory, FactoryPath.Attributes>();
        this.removeAptBuildProblemMarkers(project);
        Set<FactoryContainer> badContainers = this.verifyFactoryPath(project);
        if (badContainers != null) {
            for (FactoryContainer badFC : badContainers) {
                failureHandler.addFailedFactory(badFC.getId());
                containers.remove(badFC);
            }
        }
        if ((iterativeClassLoader = this._iterativeLoaders.get(project)) == null) {
            iterativeClassLoader = this._createIterativeClassLoader(containers);
            this._iterativeLoaders.put(project, iterativeClassLoader);
        }
        this._createBatchClassLoader(containers, project);
        ClassLoader batchClassLoader = this._batchLoaders.get(project);
        for (Map.Entry<FactoryContainer, FactoryPath.Attributes> entry : containers.entrySet()) {
            try {
                FactoryContainer fc = entry.getKey();
                FactoryPath.Attributes attr = entry.getValue();
                assert (!attr.runInBatchMode() || batchClassLoader != null);
                ClassLoader cl = attr.runInBatchMode() ? batchClassLoader : iterativeClassLoader;
                List<AnnotationProcessorFactory> java5FactoriesInContainer = this.loadJava5FactoryClasses(fc, cl, project, failureHandler);
                for (AnnotationProcessorFactory apf : java5FactoriesInContainer) {
                    java5Factories.put(apf, entry.getValue());
                }
                if (!AptPlugin.canRunJava6Processors()) continue;
                List<IServiceFactory> java6FactoriesInContainer = this.loadJava6FactoryClasses(fc, cl, project, failureHandler);
                for (IServiceFactory isf : java6FactoriesInContainer) {
                    java6Factories.put(isf, entry.getValue());
                }
            }
            catch (FileNotFoundException fnfe) {
                AptPlugin.log(fnfe, String.valueOf(Messages.AnnotationProcessorFactoryLoader_jarNotFound) + fnfe.getLocalizedMessage());
            }
            catch (IOException ioe) {
                AptPlugin.log(ioe, String.valueOf(Messages.AnnotationProcessorFactoryLoader_ioError) + ioe.getLocalizedMessage());
            }
        }
        this._project2Java5Factories.put(project, java5Factories);
        this._project2Java6Factories.put(project, java6Factories);
    }

    private List<AnnotationProcessorFactory> loadJava5FactoryClasses(FactoryContainer fc, ClassLoader classLoader, IJavaProject jproj, LoadFailureHandler failureHandler) throws IOException {
        Map<String, String> factoryNames = fc.getFactoryNames();
        ArrayList<AnnotationProcessorFactory> factories = new ArrayList<AnnotationProcessorFactory>();
        for (Map.Entry<String, String> entry : factoryNames.entrySet()) {
            if (!"com.sun.mirror.apt.AnnotationProcessorFactory".equals(entry.getValue())) continue;
            String factoryName = entry.getKey();
            AnnotationProcessorFactory factory = fc.getType() == FactoryContainer.FactoryType.PLUGIN ? FactoryPluginManager.getJava5FactoryFromPlugin(factoryName) : (AnnotationProcessorFactory)this.loadInstance(factoryName, classLoader, jproj, failureHandler);
            if (factory == null) continue;
            factories.add(factory);
        }
        return factories;
    }

    private List<IServiceFactory> loadJava6FactoryClasses(FactoryContainer fc, ClassLoader classLoader, IJavaProject jproj, LoadFailureHandler failureHandler) throws IOException {
        Map<String, String> factoryNames = fc.getFactoryNames();
        ArrayList<IServiceFactory> factories = new ArrayList<IServiceFactory>();
        for (Map.Entry<String, String> entry : factoryNames.entrySet()) {
            if (!"javax.annotation.processing.Processor".equals(entry.getValue())) continue;
            String factoryName = entry.getKey();
            IServiceFactory factory = null;
            if (fc.getType() == FactoryContainer.FactoryType.PLUGIN) {
                factory = FactoryPluginManager.getJava6FactoryFromPlugin(factoryName);
            } else {
                try {
                    Class<?> clazz = classLoader.loadClass(factoryName);
                    factory = new ClassServiceFactory(clazz);
                }
                catch (ClassNotFoundException e) {
                    AptPlugin.trace("Unable to load annotation processor " + factoryName, e);
                    failureHandler.addFailedFactory(factoryName);
                }
            }
            if (factory == null) continue;
            factories.add(factory);
        }
        return factories;
    }

    private void processChanges(Set<IJavaProject> affected, Map<IJavaProject, LoadFailureHandler> handlers) {
        for (IJavaProject jproj : affected) {
            this.removeAptBuildProblemMarkers(jproj);
            this.uncacheProject(jproj);
        }
        for (IJavaProject jproj : affected) {
            Set<FactoryContainer> badContainers;
            if (!jproj.exists() || (badContainers = this.verifyFactoryPath(jproj)) == null) continue;
            LoadFailureHandler handler = handlers.get(jproj);
            if (handler == null) {
                handler = new LoadFailureHandler(jproj);
                handlers.put(jproj, handler);
            }
            for (FactoryContainer container : badContainers) {
                handler.addMissingLibrary(container.getId());
            }
        }
    }

    private void uncacheProject(IJavaProject jproj) {
        ClassLoader cl;
        this._project2Java5Factories.remove(jproj);
        this._project2Java6Factories.remove(jproj);
        ClassLoader c = this._iterativeLoaders.remove(jproj);
        if (c instanceof JarClassLoader) {
            ((JarClassLoader)c).close();
        }
        if ((cl = this._batchLoaders.remove(jproj)) instanceof JarClassLoader) {
            ((JarClassLoader)cl).close();
        }
        this.removeProjectFromResourceMap(jproj);
    }

    private void removeAptBuildProblemMarkers(IJavaProject jproj) {
        Set<IJavaProject> jprojects = jproj == null ? this._project2Java5Factories.keySet() : Collections.singleton(jproj);
        try {
            for (IJavaProject jp : jprojects) {
                IProject p;
                IMarker[] markers;
                if (!jp.exists() || (markers = (p = jp.getProject()).findMarkers("org.eclipse.jdt.apt.core.buildproblem", false, 0)) == null) continue;
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    marker.delete();
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            AptPlugin.log(e, "Unable to delete APT build problem marker");
        }
    }

    private void removeProjectFromResourceMap(IJavaProject jproj) {
        Iterator<Map.Entry<String, Set<IJavaProject>>> i = this._container2Project.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Set<IJavaProject>> e = i.next();
            Set<IJavaProject> s = e.getValue();
            s.remove(jproj);
            if (!s.isEmpty()) continue;
            i.remove();
        }
    }

    private Set<FactoryContainer> verifyFactoryPath(IJavaProject jproj) {
        HashSet<FactoryContainer> badContainers = null;
        FactoryPath fp = FactoryPathUtil.getFactoryPath(jproj);
        Map<FactoryContainer, FactoryPath.Attributes> containers = fp.getEnabledContainers();
        for (FactoryContainer fc : containers.keySet()) {
            if (fc instanceof JarFactoryContainer) {
                try {
                    File jarFile = ((JarFactoryContainer)fc).getJarFile();
                    if (jarFile != null) {
                        String key = jarFile.getCanonicalPath();
                        this.addToResourcesMap(key, jproj);
                    }
                }
                catch (IOException iOException) {}
            }
            if (fc.exists()) continue;
            if (badContainers == null) {
                badContainers = new HashSet<FactoryContainer>();
            }
            badContainers.add(fc);
        }
        return badContainers;
    }

    private ClassLoader _createIterativeClassLoader(Map<FactoryContainer, FactoryPath.Attributes> containers) {
        ArrayList<File> fileList = new ArrayList<File>(containers.size());
        for (Map.Entry<FactoryContainer, FactoryPath.Attributes> entry : containers.entrySet()) {
            FactoryPath.Attributes attr = entry.getValue();
            FactoryContainer fc = entry.getKey();
            if (attr.runInBatchMode() || !(fc instanceof JarFactoryContainer)) continue;
            JarFactoryContainer jfc = (JarFactoryContainer)fc;
            fileList.add(jfc.getJarFile());
        }
        ClassLoader cl = fileList.size() > 0 ? AnnotationProcessorFactoryLoader.createClassLoader(fileList, AnnotationProcessorFactoryLoader.class.getClassLoader()) : AnnotationProcessorFactoryLoader.class.getClassLoader();
        return cl;
    }

    private void _createBatchClassLoader(Map<FactoryContainer, FactoryPath.Attributes> containers, IJavaProject p) {
        ArrayList<File> fileList = new ArrayList<File>(containers.size());
        for (Map.Entry<FactoryContainer, FactoryPath.Attributes> entry : containers.entrySet()) {
            FactoryPath.Attributes attr = entry.getValue();
            FactoryContainer fc = entry.getKey();
            if (!attr.runInBatchMode() || !(fc instanceof JarFactoryContainer)) continue;
            JarFactoryContainer jfc = (JarFactoryContainer)fc;
            File f = jfc.getJarFile();
            fileList.add(f);
        }
        ClassLoader parentCL = this._iterativeLoaders.get(p);
        if (parentCL == null) {
            parentCL = AnnotationProcessorFactoryLoader.class.getClassLoader();
        }
        if (fileList.size() > 0) {
            this._batchLoaders.put(p, AnnotationProcessorFactoryLoader.createClassLoader(fileList, parentCL));
        }
    }

    private static ClassLoader createClassLoader(List<File> files, ClassLoader parentCL) {
        ArrayList<URL> urls = new ArrayList<URL>(files.size());
        int i = 0;
        while (i < files.size()) {
            try {
                urls.add(files.get(i).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        return new URLClassLoader(urlArray, parentCL);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FactoryPathDeltaVisitor
    implements IResourceDeltaVisitor {
        private Set<IJavaProject> _affected = null;

        private FactoryPathDeltaVisitor() {
        }

        private void addAffected(Set<IJavaProject> projects) {
            if (this._affected == null) {
                this._affected = new HashSet<IJavaProject>(5);
            }
            this._affected.addAll(projects);
        }

        public Set<IJavaProject> getAffectedProjects() {
            return this._affected;
        }

        public boolean visit(IResourceDelta delta) {
            switch (delta.getKind()) {
                default: {
                    return true;
                }
                case 1: 
                case 2: 
                case 4: 
            }
            IResource res = delta.getResource();
            if (res == null) {
                return true;
            }
            IProject proj = res.getProject();
            if (FactoryPathUtil.isFactoryPathFile(res)) {
                this.addAffected(Collections.singleton(JavaCore.create((IProject)proj)));
                return true;
            }
            if (res.getType() != 1) {
                return true;
            }
            IPath relativePath = res.getFullPath();
            String ext = relativePath.getFileExtension();
            try {
                if (AnnotationProcessorFactoryLoader.JAR_EXTENSION.equals(ext)) {
                    IPath absolutePath = res.getLocation();
                    if (absolutePath == null) {
                        for (Map.Entry entry : AnnotationProcessorFactoryLoader.this._container2Project.entrySet()) {
                            Path jarPath = new Path((String)entry.getKey());
                            if (!relativePath.lastSegment().equals(jarPath.lastSegment())) continue;
                            this.addAffected((Set)entry.getValue());
                        }
                    } else {
                        String key = null;
                        key = absolutePath.toFile().getCanonicalPath();
                        Set projects = (Set)AnnotationProcessorFactoryLoader.this._container2Project.get(key);
                        if (projects != null) {
                            this.addAffected(projects);
                        }
                    }
                }
            }
            catch (Exception e) {
                AptPlugin.log(e, "Couldn't determine whether any factory paths were affected by change to resource " + res.getName());
            }
            return true;
        }
    }

    private class ResourceListener
    implements IResourceChangeListener {
        private ResourceListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceChanged(IResourceChangeEvent event) {
            HashMap failureHandlers = new HashMap();
            AnnotationProcessorFactoryLoader annotationProcessorFactoryLoader = AnnotationProcessorFactoryLoader.this;
            synchronized (annotationProcessorFactoryLoader) {
                switch (event.getType()) {
                    case 4: {
                        IJavaProject jproj;
                        IResource project = event.getResource();
                        if (project == null || !(project instanceof IProject) || (jproj = JavaCore.create((IProject)((IProject)project))) == null) break;
                        AnnotationProcessorFactoryLoader.this.uncacheProject(jproj);
                        break;
                    }
                    case 8: {
                        IResourceDelta rootDelta = event.getDelta();
                        FactoryPathDeltaVisitor visitor = new FactoryPathDeltaVisitor();
                        try {
                            rootDelta.accept((IResourceDeltaVisitor)visitor);
                        }
                        catch (CoreException e) {
                            AptPlugin.log(e, "Unable to determine whether resource change affects annotation processor factory path");
                        }
                        Set<IJavaProject> affected = visitor.getAffectedProjects();
                        if (affected == null) break;
                        AnnotationProcessorFactoryLoader.this.processChanges(affected, failureHandlers);
                    }
                }
            }
            for (LoadFailureHandler handler : failureHandlers.values()) {
                handler.reportFailureMarkers();
            }
        }
    }
}

