/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.xml;

import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.utils.xml.DocumentAttribute;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.utils.xml.DocumentTextNode;
import org.eclipse.wb.internal.core.utils.xml.Model;
import org.eclipse.wb.internal.core.utils.xml.parser.QAttribute;
import org.eclipse.wb.internal.core.utils.xml.parser.QHandlerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDocumentHandler
extends QHandlerAdapter {
    private DocumentElement m_rootNode;
    private final Stack<DocumentElement> m_nodeStack = new Stack();

    public DocumentElement getRootNode() {
        return this.m_rootNode;
    }

    @Override
    public final void startElement(int offset, int length, String qName, Map<String, String> attributes, List<QAttribute> attrList, boolean closed) throws Exception {
        DocumentElement parent = this.m_nodeStack.isEmpty() ? null : this.m_nodeStack.peek();
        DocumentElement element = this.getDocumentNode(qName, parent);
        element.setTag(qName);
        element.setOffset(offset);
        element.setClosed(closed);
        if (!closed) {
            element.setOpenTagOffset(offset);
            element.setOpenTagLength(length);
        }
        this.appendChildToParent(parent, element);
        this.m_nodeStack.push(element);
        for (QAttribute qdAttribute : attrList) {
            String attName = qdAttribute.getName();
            String attValue = qdAttribute.getValue();
            DocumentAttribute attribute = this.getDocumentAttribute(element, attName, attValue);
            attribute.setNameOffset(qdAttribute.getNameOffset());
            attribute.setNameLength(qdAttribute.getNameLength());
            attribute.setValueOffset(qdAttribute.getValueOffset());
            attribute.setValueLength(qdAttribute.getValueLength());
        }
    }

    @Override
    public final void endElement(int offset, int endOffset, String tag) throws Exception {
        DocumentElement element = this.m_nodeStack.pop();
        element.setLength(endOffset - element.getOffset());
        if (!element.isClosed()) {
            element.setCloseTagOffset(offset);
            element.setCloseTagLength(endOffset - offset);
        }
    }

    @Override
    public final void text(String text, boolean isCDATA) throws Exception {
        DocumentElement element;
        if (!StringUtils.isWhitespace((String)text) && !this.m_nodeStack.isEmpty() && (element = this.m_nodeStack.peek()).getTextNode() == null) {
            DocumentTextNode textNode = new DocumentTextNode(isCDATA);
            textNode.setText(text);
            int offset = element.getOpenTagOffset() + element.getOpenTagLength();
            int length = text.length();
            if (isCDATA) {
                length += "<![CDATA[]]>".length();
            }
            textNode.setLength(length);
            textNode.setOffset(offset);
            element.setTextNode(textNode);
        }
    }

    private void appendChildToParent(DocumentElement parent, DocumentElement child) {
        if (child != null) {
            if (parent != null) {
                parent.addChild(child);
            } else {
                this.m_rootNode = child;
            }
        }
    }

    protected DocumentElement getDocumentNode(String name, DocumentElement parent) {
        DocumentElement element = new DocumentElement();
        if (parent == null) {
            element.setModel(new Model());
        }
        return element;
    }

    private DocumentAttribute getDocumentAttribute(DocumentElement element, String name, String value) {
        return element.setAttribute(name, value);
    }
}

