/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.archetype;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.archetype.ArchetypeUtil;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogsWriter;

public class ArchetypeManager {
    private final Map<String, ArchetypeCatalogFactory> catalogs = new LinkedHashMap<String, ArchetypeCatalogFactory>();
    private final File configFile;
    private final ArchetypeCatalogsWriter writer;

    public ArchetypeManager(File configFile) {
        this.configFile = configFile;
        this.writer = new ArchetypeCatalogsWriter();
    }

    public Collection<ArchetypeCatalogFactory> getArchetypeCatalogs() {
        return new ArrayList<ArchetypeCatalogFactory>(this.catalogs.values());
    }

    public void addArchetypeCatalogFactory(ArchetypeCatalogFactory factory) {
        if (factory != null) {
            this.catalogs.put(factory.getId(), factory);
        }
    }

    public void removeArchetypeCatalogFactory(String catalogId) {
        this.catalogs.remove(catalogId);
    }

    public ArchetypeCatalogFactory getArchetypeCatalogFactory(String catalogId) {
        return this.catalogs.get(catalogId);
    }

    public void readCatalogs() throws IOException {
        if (this.configFile.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(this.configFile);
                Collection<ArchetypeCatalogFactory> catalogs = this.writer.readArchetypeCatalogs(is);
                Iterator<ArchetypeCatalogFactory> it = catalogs.iterator();
                while (it.hasNext()) {
                    this.addArchetypeCatalogFactory(it.next());
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
            IOUtil.close((InputStream)is);
        }
    }

    public void saveCatalogs() throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this.configFile);
            this.writer.writeArchetypeCatalogs(this.getArchetypeCatalogs(), os);
        }
        catch (Throwable throwable) {
            IOUtil.close(os);
            throw throwable;
        }
        IOUtil.close((OutputStream)os);
    }

    public <T extends ArchetypeCatalogFactory> T findParentCatalogFactory(Archetype archetype, Class<T> type) throws CoreException {
        if (archetype != null) {
            for (ArchetypeCatalogFactory factory : this.getArchetypeCatalogs()) {
                if (!type.isAssignableFrom(factory.getClass()) || factory.getDescription() != null && factory.getDescription().startsWith("Test")) continue;
                List archetypes = factory.getArchetypeCatalog().getArchetypes();
                for (Archetype knownArchetype : archetypes) {
                    if (!ArchetypeUtil.areEqual(archetype, knownArchetype)) continue;
                    return (T)factory;
                }
            }
        }
        return null;
    }

    public ArtifactRepository getArchetypeRepository(Archetype archetype) throws CoreException {
        ArchetypeCatalogFactory.RemoteCatalogFactory catalogFactory;
        String repoUrl = archetype.getRepository();
        if (repoUrl == null && (catalogFactory = this.findParentCatalogFactory(archetype, ArchetypeCatalogFactory.RemoteCatalogFactory.class)) != null) {
            repoUrl = catalogFactory.getRepositoryUrl();
        }
        return repoUrl == null ? null : MavenPlugin.getMaven().createArtifactRepository(String.valueOf(archetype.getArtifactId()) + "-repo", repoUrl);
    }

    public List<?> getRequiredProperties(Archetype archetype, ArtifactRepository remoteArchetypeRepository, IProgressMonitor monitor) throws UnknownArchetype, CoreException {
        final class WrappedUnknownArchetype
        extends RuntimeException {
            public WrappedUnknownArchetype(UnknownArchetype ex) {
                super(ex);
            }
        }
        Assert.isNotNull((Object)archetype, (String)"Archetype can not be null");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        final String groupId = archetype.getGroupId();
        final String artifactId = archetype.getArtifactId();
        final String version = archetype.getVersion();
        IMaven maven = MavenPlugin.getMaven();
        final List<ArtifactRepository> repositories = remoteArchetypeRepository == null ? maven.getArtifactRepositories() : Collections.singletonList(remoteArchetypeRepository);
        try {
            return (List)maven.execute(new ICallable<List<?>>(){

                @Override
                public List<?> call(IMavenExecutionContext context, IProgressMonitor monitor) {
                    ArtifactRepository localRepository;
                    ArchetypeArtifactManager aaMgr = MavenPluginActivator.getDefault().getArchetypeArtifactManager();
                    if (aaMgr.isFileSetArchetype(groupId, artifactId, version, null, localRepository = context.getLocalRepository(), repositories)) {
                        ArchetypeDescriptor descriptor;
                        try {
                            descriptor = aaMgr.getFileSetArchetypeDescriptor(groupId, artifactId, version, null, localRepository, repositories);
                        }
                        catch (UnknownArchetype ex) {
                            throw new WrappedUnknownArchetype(ex);
                        }
                        return descriptor.getRequiredProperties();
                    }
                    return null;
                }
            }, monitor);
        }
        catch (WrappedUnknownArchetype e) {
            throw (UnknownArchetype)e.getCause();
        }
    }
}

