/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.m2e.editor.xml.PomHyperlinkDetector;
import org.eclipse.m2e.editor.xml.PomTextHover;
import org.eclipse.m2e.editor.xml.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public class MarkerHoverControl
extends AbstractInformationControl
implements IInformationControlExtension2,
IInformationControlExtension3,
IInformationControlExtension5 {
    private PomTextHover.CompoundRegion region;
    private Control focusControl;
    private Composite parent;
    private final DefaultMarkerAnnotationAccess markerAccess = new DefaultMarkerAnnotationAccess();

    public MarkerHoverControl(Shell shell) {
        super(shell, EditorsUI.getTooltipAffordanceString());
        this.create();
    }

    public void setInput(Object input) {
        assert (input instanceof PomTextHover.CompoundRegion);
        if (!(input instanceof PomTextHover.CompoundRegion)) {
            throw new IllegalStateException("Not CompoundRegion");
        }
        this.region = (PomTextHover.CompoundRegion)input;
        this.disposeDeferredCreatedContent();
        this.deferredCreateContent();
    }

    Shell getMyShell() {
        return super.getShell();
    }

    Control getRoot() {
        return this.parent;
    }

    public boolean hasContents() {
        return this.region != null;
    }

    public void setFocus() {
        super.setFocus();
        if (this.focusControl != null) {
            this.focusControl.setFocus();
        }
    }

    public final void setVisible(boolean visible) {
        if (!visible) {
            this.disposeDeferredCreatedContent();
        }
        super.setVisible(visible);
    }

    protected void disposeDeferredCreatedContent() {
        Control[] children = this.parent.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        ToolBarManager toolBarManager = this.getToolBarManager();
        if (toolBarManager != null) {
            toolBarManager.removeAll();
        }
    }

    protected void createContent(Composite parent) {
        this.parent = parent;
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
    }

    public Point computeSizeHint() {
        Point preferedSize = this.getShell().computeSize(-1, -1, true);
        Point constrains = this.getSizeConstraints();
        if (constrains == null) {
            return preferedSize;
        }
        Point constrainedSize = this.getShell().computeSize(constrains.x, -1, true);
        int width = Math.min(preferedSize.x, constrainedSize.x);
        int height = Math.max(preferedSize.y, constrainedSize.y);
        return new Point(width, height);
    }

    protected void deferredCreateContent() {
        if (this.region != null) {
            ScrolledComposite scrolledComposite = new ScrolledComposite(this.parent, 512);
            GridData gridData = new GridData(4, 4, true, true);
            scrolledComposite.setLayoutData((Object)gridData);
            scrolledComposite.setExpandVertical(false);
            scrolledComposite.setExpandHorizontal(false);
            Composite composite = new Composite((Composite)scrolledComposite, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout(1, false);
            composite.setLayout((Layout)layout);
            scrolledComposite.setContent((Control)composite);
            for (IRegion reg : this.region.getRegions()) {
                Link link;
                if (reg instanceof PomHyperlinkDetector.MarkerRegion) {
                    PomHyperlinkDetector.MarkerRegion markerReg = (PomHyperlinkDetector.MarkerRegion)reg;
                    this.createAnnotationInformation(composite, markerReg);
                    IMarker mark = markerReg.getAnnotation().getMarker();
                    IMarkerResolution[] resolutions = IDE.getMarkerHelpRegistry().getResolutions(mark);
                    if (resolutions.length > 0) {
                        this.createResolutionsControl(composite, mark, resolutions);
                    }
                }
                if (reg instanceof PomHyperlinkDetector.ManagedArtifactRegion) {
                    final PomHyperlinkDetector.ManagedArtifactRegion man = (PomHyperlinkDetector.ManagedArtifactRegion)reg;
                    Composite comp = this.createTooltipComposite(composite, PomTextHover.getLabelForRegion(man));
                    if (PomHyperlinkDetector.canCreateHyperLink(man)) {
                        link = this.createHyperlink(comp);
                        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                MarkerHoverControl.this.dispose();
                                PomHyperlinkDetector.createHyperlink(man).open();
                            }
                        });
                    }
                }
                if (reg instanceof PomHyperlinkDetector.ExpressionRegion) {
                    final PomHyperlinkDetector.ExpressionRegion expr = (PomHyperlinkDetector.ExpressionRegion)reg;
                    Composite tooltipComposite = this.createTooltipComposite(composite, PomTextHover.getLabelForRegion(expr));
                    if (PomHyperlinkDetector.canCreateHyperLink(expr)) {
                        link = this.createHyperlink(tooltipComposite);
                        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                MarkerHoverControl.this.dispose();
                                PomHyperlinkDetector.createHyperlink(expr).open();
                            }
                        });
                    }
                }
                if (this.region.getRegions().indexOf(reg) >= this.region.getRegions().size() - 1) continue;
                this.createSeparator(composite);
            }
            Point constraints = this.getSizeConstraints();
            Point contentSize = composite.computeSize(constraints != null ? constraints.x : -1, -1);
            composite.setSize(new Point(contentSize.x, contentSize.y));
        }
        this.setColorAndFont((Control)this.parent, this.parent.getForeground(), this.parent.getBackground(), JFaceResources.getDialogFont());
        this.parent.layout(true);
    }

    private Link createHyperlink(Composite parent) {
        Link link = new Link(parent, 0);
        GridData data2 = new GridData(4, 4, true, true);
        data2.horizontalIndent = 18;
        link.setLayoutData((Object)data2);
        link.setText(Messages.PomTextHover_jump_to);
        return link;
    }

    private Composite createTooltipComposite(Composite parent, StyledString text) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        Canvas canvas = new Canvas(composite, 524288);
        GridData gridData = new GridData(1, 1, false, false);
        gridData.widthHint = 17;
        gridData.heightHint = 16;
        canvas.setLayoutData((Object)gridData);
        StyledText styledtext = new StyledText(composite, 74);
        GridData data = new GridData(4, 4, true, true);
        styledtext.setLayoutData((Object)data);
        styledtext.setText(text.getString());
        styledtext.setStyleRanges(text.getStyleRanges());
        new Label(composite, 0);
        return composite;
    }

    private void setColorAndFont(Control control, Color foreground, Color background, Font font) {
        control.setForeground(foreground);
        control.setBackground(background);
        control.setFont(font);
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                this.setColorAndFont(children[i], foreground, background, font);
                ++i;
            }
        }
    }

    private void createAnnotationInformation(Composite parent, final PomHyperlinkDetector.MarkerRegion annotation) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        final Canvas canvas = new Canvas(composite, 524288);
        GridData gridData = new GridData(1, 1, false, false);
        gridData.widthHint = 17;
        gridData.heightHint = 16;
        canvas.setLayoutData((Object)gridData);
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setFont(null);
                MarkerHoverControl.this.markerAccess.paint((Annotation)annotation.getAnnotation(), e.gc, canvas, new Rectangle(0, 0, 16, 16));
            }
        });
        StyledText text = new StyledText(composite, 74);
        GridData data = new GridData(4, 4, true, true);
        text.setLayoutData((Object)data);
        String annotationText = annotation.getAnnotation().getText();
        if (annotationText != null) {
            text.setText(annotationText);
        }
        if (annotation.isDefinedInParent()) {
            new Label(composite, 0);
            Link link = new Link(composite, 0);
            GridData data2 = new GridData(4, 4, true, true);
            data2.horizontalIndent = 18;
            link.setLayoutData((Object)data2);
            link.setText("<a>Jump to definition in parent POM</a>");
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PomHyperlinkDetector.createHyperlink(annotation).open();
                    MarkerHoverControl.this.dispose();
                }
            });
        }
    }

    private void createSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData(4, 128, true, false);
        gridData.verticalIndent = 2;
        separator.setLayoutData((Object)gridData);
    }

    private void createResolutionsControl(Composite parent, IMarker mark, IMarkerResolution[] resolutions) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label quickFixLabel = new Label(composite, 0);
        GridData layoutData = new GridData(1, 128, false, false);
        layoutData.horizontalIndent = 4;
        quickFixLabel.setLayoutData((Object)layoutData);
        String text = resolutions.length == 1 ? Messages.PomTextHover_one_quickfix : NLS.bind((String)Messages.PomTextHover_more_quickfixes, (Object)String.valueOf(resolutions.length));
        quickFixLabel.setText(text);
        Composite composite2 = new Composite(parent, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginLeft = 5;
        layout2.verticalSpacing = 2;
        composite2.setLayout((Layout)layout2);
        ArrayList<Link> list = new ArrayList<Link>();
        int i = 0;
        while (i < resolutions.length) {
            list.add(this.createCompletionProposalLink(composite2, mark, resolutions[i], 1));
            ++i;
        }
        final Link[] links = list.toArray(new Link[list.size()]);
        this.focusControl = links[0];
        int i2 = 0;
        while (i2 < links.length) {
            final int index = i2++;
            Link link = links[index];
            link.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    switch (e.keyCode) {
                        case 0x1000002: {
                            if (index + 1 >= links.length) break;
                            links[index + 1].setFocus();
                            break;
                        }
                        case 0x1000001: {
                            if (index <= 0) break;
                            links[index - 1].setFocus();
                            break;
                        }
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
        }
    }

    private Link createCompletionProposalLink(Composite parent, final IMarker mark, final IMarkerResolution proposal, int count) {
        boolean isMultiFix;
        boolean bl = isMultiFix = count > 1;
        if (isMultiFix) {
            new Label(parent, 0);
            parent = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            parent.setLayout((Layout)layout);
        }
        Label proposalImage = new Label(parent, 0);
        proposalImage.setLayoutData((Object)new GridData(1, 128, false, false));
        Image image = null;
        if (proposal instanceof ICompletionProposal) {
            image = ((ICompletionProposal)proposal).getImage();
        } else if (proposal instanceof IMarkerResolution2) {
            image = ((IMarkerResolution2)proposal).getImage();
        }
        if (image != null) {
            proposalImage.setImage(image);
            proposalImage.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    if (e.button == 1) {
                        MarkerHoverControl.this.apply(proposal, mark, ((MarkerHoverControl)MarkerHoverControl.this).region.textViewer, ((MarkerHoverControl)MarkerHoverControl.this).region.textOffset);
                    }
                }
            });
        }
        Link proposalLink = new Link(parent, 64);
        GridData layoutData = new GridData(1, 128, false, false);
        String linkText = isMultiFix ? NLS.bind((String)Messages.PomTextHover_category_fix, (Object)new Integer(count)) : proposal.getLabel();
        proposalLink.setText("<a>" + linkText + "</a>");
        proposalLink.setLayoutData((Object)layoutData);
        proposalLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarkerHoverControl.this.apply(proposal, mark, ((MarkerHoverControl)MarkerHoverControl.this).region.textViewer, ((MarkerHoverControl)MarkerHoverControl.this).region.textOffset);
            }
        });
        return proposalLink;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new MarkerHoverControl(parent);
            }
        };
    }

    private void apply(IMarkerResolution res, IMarker mark, ITextViewer viewer, int offset) {
        if (res instanceof ICompletionProposal) {
            this.apply((ICompletionProposal)res, viewer, offset, false);
        } else {
            this.dispose();
            res.run(mark);
        }
    }

    private void apply(ICompletionProposal p, ITextViewer viewer, int offset, boolean isMultiFix) {
        this.dispose();
        IRewriteTarget target = null;
        try {
            ICompletionProposalExtension2 e;
            IDocument document = viewer.getDocument();
            if (viewer instanceof ITextViewerExtension) {
                ITextViewerExtension extension = (ITextViewerExtension)viewer;
                target = extension.getRewriteTarget();
            }
            if (target != null) {
                target.beginCompoundChange();
            }
            if (p instanceof ICompletionProposalExtension2) {
                e = (ICompletionProposalExtension2)p;
                e.apply(viewer, '\u0000', isMultiFix ? 262144 : 0, offset);
            } else if (p instanceof ICompletionProposalExtension) {
                e = (ICompletionProposalExtension)p;
                e.apply(document, '\u0000', offset);
            } else {
                p.apply(document);
            }
            Point selection = p.getSelection(document);
            if (selection != null) {
                viewer.setSelectedRange(selection.x, selection.y);
                viewer.revealRange(selection.x, selection.y);
            }
        }
        finally {
            if (target != null) {
                target.endCompoundChange();
            }
        }
    }
}

