/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Globs {
    public static Pattern compileRegex(String glob) {
        String regex = Globs.toRegex(glob);
        return Pattern.compile(regex);
    }

    private static String toRegex(String glob) {
        StringBuilder sb = new StringBuilder("^");
        char[] cArray = glob.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '*': {
                    sb.append(".*");
                    break;
                }
                case '?': {
                    sb.append('.');
                    break;
                }
                case '.': {
                    sb.append("\\.");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++n2;
        }
        sb.append('$');
        return sb.toString();
    }

    public static boolean matches(String text, Pattern glob) {
        Matcher matcher = glob.matcher(text);
        return matcher.matches();
    }

    public static boolean matches(String text, String glob) {
        Pattern pattern = Globs.compileRegex(glob);
        return Globs.matches(text, pattern);
    }
}

