/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.archive;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.jar.JarFile;
import org.eclipse.recommenders.utils.Fingerprints;
import org.eclipse.recommenders.utils.Version;
import org.eclipse.recommenders.utils.archive.ArchiveMetaData;
import org.eclipse.recommenders.utils.archive.ClassId;
import org.eclipse.recommenders.utils.archive.ClassIdExtractor;
import org.eclipse.recommenders.utils.archive.FilenameJarIdExtractor;
import org.eclipse.recommenders.utils.archive.JarIdExtractor;
import org.eclipse.recommenders.utils.archive.MavenPomJarIdExtractor;
import org.eclipse.recommenders.utils.archive.OsgiManifestJarIdExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveDetailsExtractor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JarFile jarFile;
    private final File file;
    private List<JarIdExtractor> jarIdExtractors;
    private ClassIdExtractor classIdExtractor;
    private String lazyFingerprint;
    private String lazyName;
    private Version lazyVersion;
    private Collection<ClassId> lazyClassIds;

    public ArchiveDetailsExtractor(File file) throws IOException {
        this.initializeExtractors();
        this.file = file;
        this.jarFile = new JarFile(file);
    }

    private void initializeExtractors() {
        this.classIdExtractor = new ClassIdExtractor();
        this.jarIdExtractors = new LinkedList<JarIdExtractor>();
        this.jarIdExtractors.add(new OsgiManifestJarIdExtractor());
        this.jarIdExtractors.add(new MavenPomJarIdExtractor());
        this.jarIdExtractors.add(new FilenameJarIdExtractor());
    }

    public String createFingerprint() {
        if (this.lazyFingerprint == null) {
            this.lazyFingerprint = Fingerprints.sha1(this.file);
        }
        return this.lazyFingerprint;
    }

    private void extractJarIds() {
        for (JarIdExtractor extractor : this.jarIdExtractors) {
            try {
                extractor.extract(this.jarFile);
                this.setNameIfFound(extractor);
                this.setVersionIfFound(extractor);
                if (this.requiresJarIdExtraction()) continue;
                return;
            }
            catch (Exception e) {
                this.logger.error("Error while extracting name and version from file: " + this.jarFile.getName(), (Throwable)e);
            }
        }
        this.setFallbackJarIdIfNotExtracted();
    }

    private void setFallbackJarIdIfNotExtracted() {
        if (this.lazyName == null) {
            this.lazyName = "";
        }
        if (this.lazyVersion == null) {
            this.lazyVersion = Version.UNKNOWN;
        }
    }

    private boolean requiresJarIdExtraction() {
        return this.lazyName == null || this.lazyVersion == null;
    }

    private void setNameIfFound(JarIdExtractor extractor) {
        if (this.lazyName == null && extractor.getName() != null) {
            this.lazyName = extractor.getName();
        }
    }

    private void setVersionIfFound(JarIdExtractor extractor) {
        if (this.lazyVersion == null && !extractor.getVersion().isUnknown()) {
            this.lazyVersion = extractor.getVersion();
        }
    }

    public String extractName() {
        if (this.lazyName == null) {
            this.extractJarIds();
        }
        return this.lazyName;
    }

    public Version extractVersion() {
        if (this.lazyVersion == null) {
            this.extractJarIds();
        }
        return this.lazyVersion;
    }

    public Collection<ClassId> extractClassIds() {
        if (this.lazyClassIds == null) {
            try {
                this.classIdExtractor.extract(this.jarFile);
                this.lazyClassIds = new TreeSet<ClassId>(new Comparator<ClassId>(){

                    @Override
                    public int compare(ClassId o1, ClassId o2) {
                        return o1.typeName.compareTo(o2.typeName);
                    }
                });
                this.lazyClassIds.addAll(this.classIdExtractor.getClassIds());
            }
            catch (Exception e) {
                this.logger.error("Error while extracting class ids from file: " + this.jarFile.getName(), (Throwable)e);
            }
        }
        return this.lazyClassIds;
    }

    public ArchiveMetaData getArchiveMetaData() {
        ArchiveMetaData archive = new ArchiveMetaData();
        archive.fingerprint = this.createFingerprint();
        archive.name = this.extractName();
        archive.version = this.extractVersion();
        archive.types = this.extractClassIds();
        return archive;
    }
}

