/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.v;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.cwt.v.VControl;
import org.eclipse.nebula.cwt.v.VNative;
import org.eclipse.nebula.cwt.v.VPanel;
import org.eclipse.nebula.cwt.v.VWidget;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VTracker
implements DisposeListener {
    private static VTracker tracker;
    private Map<Composite, VPanel> panels;
    private Map<Widget, VNative> natives;
    private VControl activeControl = null;
    private Listener filter = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 31: {
                    VTracker.this.lastTraverse = event.detail;
                    if (16 != event.detail && 8 != event.detail) break;
                    event.doit = true;
                    if (VTracker.this.focusControl != null) {
                        VTracker.this.focusControl.handleEvent(event);
                        if (!event.doit) break;
                        Composite comp = VTracker.this.focusControl.getWidget();
                        if (16 == event.detail) {
                            VTracker.setFocusToNext(comp);
                            break;
                        }
                        VTracker.setFocusToPrev(comp);
                        break;
                    }
                    if (!(event.widget instanceof Control)) break;
                    if (16 == event.detail) {
                        if (!VTracker.setFocusFromPrev((Control)event.widget)) break;
                        event.type = 0;
                        event.doit = false;
                        break;
                    }
                    if (!VTracker.setFocusFromNext((Control)event.widget)) break;
                    event.type = 0;
                    event.doit = false;
                    break;
                }
                case 15: {
                    Control[] ca;
                    if (event.widget instanceof Shell && (ca = ((Shell)event.widget).getTabList()).length > 0 && ca[0] instanceof VWidget) {
                        VTracker.this.setFocusControl(((VWidget)ca[0]).getPanel());
                    }
                    if (VTracker.this.focusControl == null) {
                        if (!(event.widget instanceof VWidget)) break;
                        VTracker.this.setFocusControl(((VWidget)event.widget).getPanel());
                        break;
                    }
                    if (VTracker.this.focusControl.isSameWidgetAs(event.widget)) {
                        if (event.widget instanceof VWidget) {
                            VTracker.this.setFocusControl(((VWidget)event.widget).getPanel());
                            break;
                        }
                        VControl control = (VControl)VTracker.this.natives.get(event.widget);
                        if (control == null) break;
                        VTracker.this.setFocusControl(control);
                        break;
                    }
                    VTracker.this.setFocusControl(null);
                    break;
                }
                case 3: {
                    VTracker.this.mouseButton = event.button;
                    VTracker.this.mouseDown = new Point(event.x, event.y);
                    if (VTracker.this.activeControl == null || !VTracker.this.activeControl.setState(32, true)) break;
                    VTracker.this.activeControl.redraw();
                    break;
                }
                case 5: {
                    if (VTracker.this.panels.containsKey(event.widget)) {
                        VControl vcontrol = ((VPanel)VTracker.this.panels.get(event.widget)).getControl(event.x, event.y, true);
                        if (vcontrol == VTracker.this.activeControl || vcontrol != null && !vcontrol.isEnabled()) break;
                        VTracker.this.activate(vcontrol);
                        break;
                    }
                    if (VTracker.this.activeControl == null || event.widget == VTracker.this.activeControl.getControl()) break;
                    VTracker.this.activeControl.deactivate();
                    VTracker.this.activeControl = null;
                    break;
                }
                case 4: {
                    VTracker.this.mouseButton = -1;
                    VTracker.this.mouseDown = null;
                    if (VTracker.this.activeControl == null || !VTracker.this.activeControl.setState(32, false)) break;
                    VTracker.this.activeControl.redraw();
                }
            }
        }
    };
    private VControl focusControl = null;
    private boolean listening = false;
    private int mouseButton = -1;
    private Point mouseDown = null;
    private int lastTraverse = -1;

    static void addNative(VNative<?> n) {
        VTracker tracker = VTracker.instance();
        if (tracker.natives == null) {
            tracker.natives = new HashMap<Widget, VNative>();
        }
        tracker.natives.put((Widget)n.control, n);
        n.control.addDisposeListener((DisposeListener)tracker);
    }

    static void addTopLevelPanel(VPanel panel) {
        VTracker tracker = VTracker.instance();
        if (tracker.panels == null) {
            tracker.panels = new HashMap<Composite, VPanel>();
        }
        tracker.panels.put(panel.composite, panel);
        if (!tracker.listening) {
            tracker.listening = true;
            Display.getDefault().addFilter(15, tracker.filter);
            Display.getDefault().addFilter(5, tracker.filter);
            Display.getDefault().addFilter(3, tracker.filter);
            Display.getDefault().addFilter(4, tracker.filter);
            Display.getDefault().addFilter(31, tracker.filter);
        }
        panel.composite.addDisposeListener((DisposeListener)tracker);
    }

    public static void deactivate() {
        VTracker.instance().deactivate(VTracker.getActiveControl());
    }

    public static int getLastTraverse() {
        return VTracker.instance().lastTraverse;
    }

    public static int getMouseDownButton() {
        return VTracker.instance().mouseButton;
    }

    public static Point getMouseDownLocation() {
        return VTracker.instance().mouseDown;
    }

    public static boolean isFocusControl(Control control) {
        VControl focusControl = VTracker.instance().focusControl;
        return focusControl != null && focusControl.isSameWidgetAs((Widget)control);
    }

    public static boolean isMouseDown() {
        return VTracker.instance().mouseDown != null;
    }

    public static VControl getFocusControl() {
        return VTracker.instance().focusControl;
    }

    public static VControl getActiveControl() {
        return VTracker.instance().activeControl;
    }

    private static boolean setFocusFromPrev(Control control) {
        Control c = null;
        Composite parent = control.getParent();
        if (parent == null) {
            c = control;
        } else {
            Control[] controlArray = parent.getTabList();
            int i = 0;
            while (i < controlArray.length) {
                if (controlArray[i] == control) {
                    if (i == controlArray.length - 1) {
                        c = controlArray[0];
                        break;
                    }
                    c = controlArray[i + 1];
                    break;
                }
                ++i;
            }
        }
        if (control != null) {
            for (VControl vControl : VTracker.instance().panels.values()) {
                Composite widget = vControl.getWidget();
                if (widget != c) continue;
                return widget.setFocus();
            }
        }
        return false;
    }

    private static boolean setFocusFromNext(Control control) {
        Control c = null;
        Composite parent = control.getParent();
        if (parent == null) {
            c = control;
        } else {
            Control[] controlArray = parent.getTabList();
            int i = 0;
            while (i < controlArray.length) {
                if (controlArray[i] == control) {
                    if (i == 0) {
                        c = controlArray[controlArray.length - 1];
                        break;
                    }
                    c = controlArray[i - 1];
                    break;
                }
                ++i;
            }
        }
        if (c != null) {
            for (VControl vControl : VTracker.instance().panels.values()) {
                Composite widget = vControl.getWidget();
                if (widget != c) continue;
                return widget.setFocus();
            }
        }
        return false;
    }

    private static void setFocusToNext(Composite comp) {
        block11: {
            if (comp == null) break block11;
            Composite parent = comp.getParent();
            Control[] controls = parent.getTabList();
            if (parent instanceof Shell) {
                int i = 0;
                while (i < controls.length) {
                    if (controls[i] == comp) {
                        int j = 0;
                        while (j < controls.length) {
                            if (++i > controls.length - 1) {
                                i = 0;
                            }
                            if (controls[i].setFocus()) {
                                return;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < controls.length) {
                    if (controls[i] == comp) {
                        while (i < controls.length - 1) {
                            if (controls[i + 1].setFocus()) {
                                return;
                            }
                            ++i;
                        }
                        VTracker.setFocusToNext(comp.getParent());
                    }
                    ++i;
                }
            }
        }
    }

    private static void setFocusToPrev(Composite comp) {
        block11: {
            if (comp == null) break block11;
            Composite parent = comp.getParent();
            Control[] controls = parent.getTabList();
            if (parent instanceof Shell) {
                int i = 0;
                while (i < controls.length) {
                    if (controls[i] == comp) {
                        int j = 0;
                        while (j < controls.length) {
                            if (--i < 0) {
                                i = controls.length - 1;
                            }
                            if (controls[i].setFocus()) {
                                return;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < controls.length) {
                    if (controls[i] == comp) {
                        while (i > 0) {
                            if (controls[i - 1].setFocus()) {
                                return;
                            }
                            --i;
                        }
                        VTracker.setFocusToPrev(comp.getParent());
                    }
                    ++i;
                }
            }
        }
    }

    static VTracker instance() {
        if (tracker == null) {
            tracker = new VTracker();
        }
        return tracker;
    }

    private VTracker() {
    }

    void activate(VControl vcontrol) {
        if (this.activeControl != null && !this.activeControl.isDisposed()) {
            this.activeControl.deactivate();
        }
        this.activeControl = vcontrol;
        if (this.activeControl != null) {
            this.activeControl.activate();
        }
    }

    void deactivate(VControl vcontrol) {
        if (vcontrol != null) {
            if (!vcontrol.isDisposed()) {
                vcontrol.deactivate();
            }
            if (this.activeControl == vcontrol) {
                this.activeControl = null;
            }
        }
    }

    boolean setFocusControl(VControl control) {
        if (control == this.focusControl) {
            return true;
        }
        if (control instanceof VPanel) {
            return control.setFocus(true);
        }
        VControl old = this.focusControl;
        if (old != null && !old.isDisposed()) {
            old.setFocus(false);
            this.focusControl = null;
        }
        if (control != null) {
            if (!control.isDisposed() && control.setFocus(true)) {
                control.getControl().forceFocus();
            } else {
                return false;
            }
        }
        this.focusControl = control;
        if (control != null) {
            control.redraw();
        }
        if (old != null && !old.isDisposed()) {
            old.redraw();
        }
        return true;
    }

    public void widgetDisposed(DisposeEvent e) {
        VTracker tracker = VTracker.instance();
        if (tracker.natives != null && tracker.natives.containsKey(e.widget)) {
            tracker.natives.remove(e.widget);
            if (tracker.natives.isEmpty()) {
                tracker.natives = null;
            }
        } else if (tracker.panels != null && tracker.panels.containsKey(e.widget)) {
            tracker.panels.remove(e.widget);
            if (tracker.panels.isEmpty()) {
                Control control;
                Display.getDefault().removeFilter(15, tracker.filter);
                Display.getDefault().removeFilter(5, tracker.filter);
                Display.getDefault().removeFilter(3, tracker.filter);
                Display.getDefault().removeFilter(4, tracker.filter);
                Display.getDefault().removeFilter(31, tracker.filter);
                tracker.listening = false;
                if (this.activeControl != null && (control = this.activeControl.getControl()) != null && !control.isDisposed()) {
                    control.dispose();
                }
                tracker.panels = null;
            }
        }
    }
}

