/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreateRepositoryPage
extends WizardPage {
    private final boolean hideBare;
    private Text directoryText;
    private Text nameText;
    private Button bareButton;

    public CreateRepositoryPage(boolean hideBareOption) {
        super(CreateRepositoryPage.class.getName());
        this.hideBare = hideBareOption;
        this.setTitle(UIText.CreateRepositoryPage_PageTitle);
        this.setMessage(UIText.CreateRepositoryPage_PageMessage);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(3, false));
        Label directoryLabel = new Label(main, 0);
        directoryLabel.setText(UIText.CreateRepositoryPage_DirectoryLabel);
        this.directoryText = new Text(main, 2048);
        this.directoryText.setText(UIUtils.getDefaultRepositoryDir());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.directoryText);
        Button browseButton = new Button(main, 8);
        browseButton.setText(UIText.CreateRepositoryPage_BrowseButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String result;
                String previous = CreateRepositoryPage.this.directoryText.getText();
                File previousFile = new File(previous);
                DirectoryDialog dialog = new DirectoryDialog(CreateRepositoryPage.this.getShell());
                if (previousFile.exists() && previousFile.isDirectory()) {
                    dialog.setFilterPath(previousFile.getPath());
                }
                if ((result = dialog.open()) != null) {
                    CreateRepositoryPage.this.directoryText.setText(result);
                }
            }
        });
        Label nameLabel = new Label(main, 0);
        nameLabel.setText(UIText.CreateRepositoryPage_RepositoryNameLabel);
        this.nameText = new Text(main, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.nameText);
        if (!this.hideBare) {
            this.bareButton = new Button(main, 32);
            this.bareButton.setText(UIText.CreateRepositoryPage_BareCheckbox);
            GridDataFactory.fillDefaults().indent(10, 0).span(3, 1).applyTo((Control)this.bareButton);
        }
        this.directoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateRepositoryPage.this.checkPage();
            }
        });
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateRepositoryPage.this.checkPage();
            }
        });
        this.setControl((Control)main);
        this.nameText.setFocus();
    }

    public String getDirectory() {
        IPath path = new Path(this.directoryText.getText()).append(this.nameText.getText());
        return path.toOSString();
    }

    public boolean getBare() {
        return this.bareButton != null && this.bareButton.getSelection();
    }

    void checkPage() {
        block12: {
            File testFile;
            String dir;
            block11: {
                block10: {
                    block9: {
                        String name;
                        block8: {
                            block7: {
                                this.setErrorMessage(null);
                                try {
                                    String parentDir = this.directoryText.getText();
                                    if (parentDir.length() != 0) break block7;
                                    this.setErrorMessage(UIText.CreateRepositoryPage_PleaseSelectDirectoryMessage);
                                }
                                catch (Throwable throwable) {
                                    this.setPageComplete(this.getErrorMessage() == null);
                                    throw throwable;
                                }
                                this.setPageComplete(this.getErrorMessage() == null);
                                return;
                            }
                            name = this.nameText.getText();
                            if (name.length() != 0) break block8;
                            this.setErrorMessage(UIText.CreateRepositoryPage_MissingNameMessage);
                            this.setPageComplete(this.getErrorMessage() == null);
                            return;
                        }
                        IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 2);
                        if (status.isOK()) break block9;
                        this.setErrorMessage(status.getMessage());
                        this.setPageComplete(this.getErrorMessage() == null);
                        return;
                    }
                    dir = this.getDirectory();
                    testFile = new File(dir);
                    Path path = new Path(dir);
                    if (path.isAbsolute()) break block10;
                    this.setErrorMessage(UIText.CreateRepositoryPage_PleaseUseAbsoluePathMessage);
                    this.setPageComplete(this.getErrorMessage() == null);
                    return;
                }
                if (!testFile.exists() || testFile.isDirectory()) break block11;
                this.setErrorMessage(NLS.bind((String)UIText.CreateRepositoryPage_NotADirectoryMessage, (Object)dir));
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            if (!testFile.exists() || testFile.list().length <= 0) break block12;
            this.setErrorMessage(NLS.bind((String)UIText.CreateRepositoryPage_NotEmptyMessage, (Object)dir));
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }
}

