/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.tasklist;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mylyn.commons.ui.PlatformUiUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.ui.BugzillaImages;
import org.eclipse.mylyn.internal.bugzilla.ui.TaskAttachmentHyperlink;
import org.eclipse.mylyn.internal.bugzilla.ui.TaskAttachmentTableEditorHyperlink;
import org.eclipse.mylyn.internal.bugzilla.ui.search.BugzillaSearchPage;
import org.eclipse.mylyn.internal.bugzilla.ui.tasklist.BugzillaCustomQueryWizardPage;
import org.eclipse.mylyn.internal.bugzilla.ui.tasklist.BugzillaQueryTypeWizardPage;
import org.eclipse.mylyn.internal.bugzilla.ui.tasklist.BugzillaRepositorySettingsPage;
import org.eclipse.mylyn.internal.bugzilla.ui.tasklist.BugzillaTaskAttachmentPage;
import org.eclipse.mylyn.internal.bugzilla.ui.wizard.NewBugzillaTaskWizard;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentModel;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.LegendElement;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.mylyn.tasks.ui.wizards.RepositoryQueryWizard;

public class BugzillaConnectorUi
extends AbstractRepositoryConnectorUi {
    private static final String BUG = "(?:duplicate of|bug|task)[ \t]*#?[ \t]*(\\d+)";
    private static final String COMMENT = "comment[ \t]*#?[ \t]*(\\d+)";
    private static final String REGEXP_BUG = "(?:\\W||^)((?:duplicate of|bug|task)[ \t]*#?[ \t]*(\\d+)(?:[ \t]*comment[ \t]*#?[ \t]*(\\d+))?)|(comment[ \t]*#?[ \t]*(\\d+))";
    private static final String REGEXP_ATTACHMENT = "(?:Created (?:an )?)?attachment[ \t]*#?[ \t]*(?:\\(id=)?(\\d+)\\)?";
    private static final Pattern PATTERN_BUG = Pattern.compile("(?:\\W||^)((?:duplicate of|bug|task)[ \t]*#?[ \t]*(\\d+)(?:[ \t]*comment[ \t]*#?[ \t]*(\\d+))?)|(comment[ \t]*#?[ \t]*(\\d+))", 2);
    private static final Pattern PATTERN_ATTACHMENT = Pattern.compile("(?:Created (?:an )?)?attachment[ \t]*#?[ \t]*(?:\\(id=)?(\\d+)\\)?", 2);
    private final boolean doAttachmentTableEditorHyperlink = PlatformUiUtil.supportsMultipleHyperlinkPresenter();

    public String getAccountCreationUrl(TaskRepository taskRepository) {
        return String.valueOf(taskRepository.getRepositoryUrl()) + "/createaccount.cgi";
    }

    public String getAccountManagementUrl(TaskRepository taskRepository) {
        return String.valueOf(taskRepository.getRepositoryUrl()) + "/userprefs.cgi";
    }

    public String getTaskHistoryUrl(TaskRepository taskRepository, ITask task) {
        return String.valueOf(taskRepository.getRepositoryUrl()) + "/show_activity.cgi?id=" + task.getTaskId();
    }

    public List<LegendElement> getLegendElements() {
        ArrayList<LegendElement> legendItems = new ArrayList<LegendElement>();
        legendItems.add(LegendElement.createTask((String)"blocker", (ImageDescriptor)BugzillaImages.OVERLAY_CRITICAL));
        legendItems.add(LegendElement.createTask((String)"critical", (ImageDescriptor)BugzillaImages.OVERLAY_CRITICAL));
        legendItems.add(LegendElement.createTask((String)"major", (ImageDescriptor)BugzillaImages.OVERLAY_CRITICAL));
        legendItems.add(LegendElement.createTask((String)"normal", null));
        legendItems.add(LegendElement.createTask((String)"minor", (ImageDescriptor)BugzillaImages.OVERLAY_MAJOR));
        legendItems.add(LegendElement.createTask((String)"enhancement", (ImageDescriptor)BugzillaImages.OVERLAY_ENHANCEMENT));
        legendItems.add(LegendElement.createTask((String)"trivial", (ImageDescriptor)BugzillaImages.OVERLAY_TRIVIAL));
        return legendItems;
    }

    public ImageDescriptor getTaskKindOverlay(ITask task) {
        String severity = task.getAttribute(BugzillaAttribute.BUG_SEVERITY.getKey());
        if (severity != null) {
            if ("blocker".equals(severity) || "critical".equals(severity) || "major".equals(severity)) {
                return BugzillaImages.OVERLAY_CRITICAL;
            }
            if ("minor".equals(severity)) {
                return BugzillaImages.OVERLAY_MAJOR;
            }
            if ("enhancement".equals(severity)) {
                return BugzillaImages.OVERLAY_ENHANCEMENT;
            }
            if ("trivial".equals(severity)) {
                return BugzillaImages.OVERLAY_TRIVIAL;
            }
            return null;
        }
        return super.getTaskKindOverlay(task);
    }

    public String getTaskKindLabel(ITask repositoryTask) {
        return "Bug";
    }

    public ITaskRepositoryPage getSettingsPage(TaskRepository taskRepository) {
        return new BugzillaRepositorySettingsPage(taskRepository);
    }

    public AbstractRepositoryQueryPage getSearchPage(TaskRepository repository, IStructuredSelection selection) {
        return new BugzillaSearchPage(repository);
    }

    public IWizard getNewTaskWizard(TaskRepository taskRepository, ITaskMapping selection) {
        return new NewBugzillaTaskWizard(taskRepository, selection);
    }

    public IWizard getQueryWizard(TaskRepository repository, IRepositoryQuery query) {
        RepositoryQueryWizard wizard = new RepositoryQueryWizard(repository);
        if (query == null) {
            wizard.addPage((IWizardPage)new BugzillaQueryTypeWizardPage(repository));
        } else if (this.isCustomQuery(query)) {
            wizard.addPage((IWizardPage)new BugzillaCustomQueryWizardPage(repository, query));
        } else {
            wizard.addPage((IWizardPage)new BugzillaSearchPage(repository, query));
        }
        return wizard;
    }

    public boolean hasSearchPage() {
        return true;
    }

    public String getConnectorKind() {
        return "bugzilla";
    }

    private boolean isCustomQuery(IRepositoryQuery query2) {
        String custom = query2.getAttribute("bugzilla.query.custom");
        return custom != null && custom.equals(Boolean.TRUE.toString());
    }

    public IWizardPage getTaskAttachmentPage(TaskAttachmentModel model) {
        return new BugzillaTaskAttachmentPage(model);
    }

    @Deprecated
    public IHyperlink[] findHyperlinks(TaskRepository repository, String text, int index, int textOffset) {
        return this.findHyperlinks(repository, null, text, index, textOffset);
    }

    public IHyperlink[] findHyperlinks(TaskRepository repository, ITask task, String text, int index, int textOffset) {
        Region region;
        ArrayList<TaskHyperlink> hyperlinksFound = null;
        Matcher mb = PATTERN_BUG.matcher(text);
        while (mb.find()) {
            if (index != -1 && (index < mb.start() || index > mb.end())) continue;
            TaskHyperlink link = null;
            if (mb.group(1) != null) {
                region = new Region(textOffset + mb.start(1), mb.end(1) - mb.start(1));
                link = new TaskHyperlink((IRegion)region, repository, mb.group(2));
                if (mb.group(3) != null) {
                    link.setSelection((Object)("task.common.comment-" + mb.group(3)));
                }
            } else if (task != null && mb.group(4) != null) {
                region = new Region(textOffset + mb.start(4), mb.end(4) - mb.start(4));
                link = new TaskHyperlink((IRegion)region, repository, task.getTaskId());
                link.setSelection((Object)("task.common.comment-" + mb.group(5)));
            }
            if (link == null) continue;
            if (hyperlinksFound == null) {
                hyperlinksFound = new ArrayList<TaskHyperlink>();
            }
            hyperlinksFound.add(link);
        }
        Matcher ma = PATTERN_ATTACHMENT.matcher(text);
        while (ma.find()) {
            if (index != -1 && (index < ma.start() || index > ma.end())) continue;
            region = new Region(textOffset + ma.start(), ma.end() - ma.start());
            TaskAttachmentHyperlink link0 = new TaskAttachmentHyperlink((IRegion)region, repository, ma.group(1));
            if (hyperlinksFound == null) {
                hyperlinksFound = new ArrayList();
            }
            hyperlinksFound.add((TaskHyperlink)link0);
            if (!this.doAttachmentTableEditorHyperlink) continue;
            hyperlinksFound.add((TaskHyperlink)new TaskAttachmentTableEditorHyperlink((IRegion)region, repository, ma.group(1)));
        }
        return hyperlinksFound != null ? hyperlinksFound.toArray(new IHyperlink[0]) : null;
    }
}

