/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package camelinaction;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;

/**
 * A Camel Router
 *
 * @version $
 */
public class MyRouteBuilder extends RouteBuilder {

    /**
     * Lets configure the Camel routing rules using Java code...
     */
    public void configure() {
        from("ftp://rider@localhost:21000/order?password=secret&delete=true")
          .to("log:camelinaction.order.ftp")
          .to("jms:incomingOrders");

        from("cxf:bean:orderEndpoint")
          .to("log:camelinaction.order.ws")
          .inOnly("jms:incomingOrders")
          .transform(constant("OK"));

        from("jms:incomingOrders")
          .to("log:camelinaction.order.jms");
    }
}
