/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring3.xml.encryption;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jasypt.digest.config.EnvironmentDigesterConfig;
import org.jasypt.digest.config.EnvironmentStringDigesterConfig;
import org.jasypt.digest.config.SimpleDigesterConfig;
import org.jasypt.digest.config.SimpleStringDigesterConfig;
import org.jasypt.spring3.xml.encryption.AbstractEncryptionBeanDefinitionParser;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DigesterConfigBeanDefinitionParser
extends AbstractEncryptionBeanDefinitionParser {
    private static final String SCOPE_ATTRIBUTE = "scope";
    private static final String PARAM_ALGORITHM = "algorithm";
    private static final String PARAM_ITERATIONS = "iterations";
    private static final String PARAM_SALT_SIZE_BYTES = "salt-size-bytes";
    private static final String PARAM_SALT_GENERATOR_BEAN = "salt-generator-bean";
    private static final String PARAM_SALT_GENERATOR_CLASS_NAME = "salt-generator-class-name";
    private static final String PARAM_PROVIDER_BEAN = "provider-bean";
    private static final String PARAM_PROVIDER_CLASS_NAME = "provider-class-name";
    private static final String PARAM_PROVIDER_NAME = "provider-name";
    private static final String PARAM_INVERT_POSITION_OF_SALT_IN_MESSAGE_BEFORE_DIGESTING = "invert-position-of-salt-in-message-before-digesting";
    private static final String PARAM_INVERT_POSITION_OF_PLAIN_SALT_IN_ENCRYPTION_RESULTS = "invert-position-of-plain-salt-in-encryption-results";
    private static final String PARAM_USE_LENIENT_SALT_SIZE_CHECK = "use-lenient-salt-size-check";
    private static final String PARAM_POOL_SIZE = "pool-size";
    private static final Set<String> PARAMS_SIMPLE = new HashSet<String>(Arrays.asList("algorithm", "iterations", "salt-size-bytes", "salt-generator-bean", "salt-generator-class-name", "provider-bean", "provider-class-name", "provider-name", "invert-position-of-salt-in-message-before-digesting", "invert-position-of-plain-salt-in-encryption-results", "use-lenient-salt-size-check", "pool-size"));
    private static final String PARAM_STRING_OUTPUT_TYPE = "string-output-type";
    private static final String PARAM_UNICODE_NORMALIZATION_IGNORED = "unicode-normalization-ignored";
    private static final String PARAM_PREFIX = "prefix";
    private static final String PARAM_SUFFIX = "suffix";
    private static final Set<String> PARAMS_STRING = new HashSet<String>(Arrays.asList("string-output-type", "unicode-normalization-ignored", "prefix", "suffix"));
    private static final String PARAM_ALGORITHM_ENV_NAME = "algorithm-env-name";
    private static final String PARAM_ALGORITHM_SYS_PROPERTY_NAME = "algorithm-sys-property-name";
    private static final String PARAM_ITERATIONS_ENV_NAME = "iterations-env-name";
    private static final String PARAM_ITERATIONS_SYS_PROPERTY_NAME = "iterations-sys-property-name";
    private static final String PARAM_SALT_SIZE_BYTES_ENV_NAME = "salt-size-bytes-env-name";
    private static final String PARAM_SALT_SIZE_BYTES_SYS_PROPERTY_NAME = "salt-size-bytes-sys-property-name";
    private static final String PARAM_SALT_GENERATOR_CLASS_NAME_ENV_NAME = "salt-generator-class-name-env-name";
    private static final String PARAM_SALT_GENERATOR_CLASS_NAME_SYS_PROPERTY_NAME = "salt-generator-class-name-sys-property-name";
    private static final String PARAM_PROVIDER_CLASS_NAME_ENV_NAME = "provider-class-name-env-name";
    private static final String PARAM_PROVIDER_CLASS_NAME_SYS_PROPERTY_NAME = "provider-class-name-sys-property-name";
    private static final String PARAM_PROVIDER_NAME_ENV_NAME = "provider-name-env-name";
    private static final String PARAM_PROVIDER_NAME_SYS_PROPERTY_NAME = "provider-name-sys-property-name";
    private static final String PARAM_INVERT_POSITION_OF_SALT_IN_MESSAGE_BEFORE_DIGESTING_ENV_NAME = "invert-position-of-salt-in-message-before-digesting-env-name";
    private static final String PARAM_INVERT_POSITION_OF_SALT_IN_MESSAGE_BEFORE_DIGESTING_SYS_PROPERTY_NAME = "invert-position-of-salt-in-message-before-digesting-sys-property-name";
    private static final String PARAM_INVERT_POSITION_OF_PLAIN_SALT_IN_ENCRYPTION_RESULTS_ENV_NAME = "invert-position-of-plain-salt-in-encryption-results-env-name";
    private static final String PARAM_INVERT_POSITION_OF_PLAIN_SALT_IN_ENCRYPTION_RESULTS_SYS_PROPERTY_NAME = "invert-position-of-plain-salt-in-encryption-results-sys-property-name";
    private static final String PARAM_USE_LENIENT_SALT_SIZE_CHECK_ENV_NAME = "use-lenient-salt-size-check-env-name";
    private static final String PARAM_USE_LENIENT_SALT_SIZE_CHECK_SYS_PROPERTY_NAME = "use-lenient-salt-size-check-sys-property-name";
    private static final String PARAM_POOL_SIZE_ENV_NAME = "pool-size-env-name";
    private static final String PARAM_POOL_SIZE_SYS_PROPERTY_NAME = "pool-size-sys-property-name";
    private static final Set<String> PARAMS_ENVIRONMENT = new HashSet<String>(Arrays.asList("algorithm-env-name", "algorithm-sys-property-name", "iterations-env-name", "iterations-sys-property-name", "salt-size-bytes-env-name", "salt-size-bytes-sys-property-name", "salt-generator-class-name-env-name", "salt-generator-class-name-sys-property-name", "provider-class-name-env-name", "provider-class-name-sys-property-name", "provider-name-env-name", "provider-name-sys-property-name", "invert-position-of-salt-in-message-before-digesting-env-name", "invert-position-of-salt-in-message-before-digesting-sys-property-name", "invert-position-of-plain-salt-in-encryption-results-env-name", "invert-position-of-plain-salt-in-encryption-results-sys-property-name", "use-lenient-salt-size-check-env-name", "use-lenient-salt-size-check-sys-property-name", "pool-size-env-name", "pool-size-sys-property-name"));
    private static final String PARAM_STRING_OUTPUT_TYPE_ENV_NAME = "string-output-type-env-name";
    private static final String PARAM_STRING_OUTPUT_TYPE_SYS_PROPERTY_NAME = "string-output-type-sys-property-name";
    private static final String PARAM_UNICODE_NORMALIZATION_IGNORED_ENV_NAME = "unicode-normalization-ignored-env-name";
    private static final String PARAM_UNICODE_NORMALIZATION_IGNORED_SYS_PROPERTY_NAME = "unicode-normalization-ignored-sys-property-name";
    private static final String PARAM_PREFIX_ENV_NAME = "prefix-env-name";
    private static final String PARAM_PREFIX_SYS_PROPERTY_NAME = "prefix-sys-property-name";
    private static final String PARAM_SUFFIX_ENV_NAME = "suffix-env-name";
    private static final String PARAM_SUFFIX_SYS_PROPERTY_NAME = "suffix-sys-property-name";
    private static final Set<String> PARAMS_STRING_ENVIRONMENT = new HashSet<String>(Arrays.asList("string-output-type-env-name", "string-output-type-sys-property-name", "unicode-normalization-ignored-env-name", "unicode-normalization-ignored-sys-property-name", "prefix-env-name", "prefix-sys-property-name", "suffix-env-name", "suffix-sys-property-name"));

    DigesterConfigBeanDefinitionParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return DigesterConfigBeanDefinitionParser.computeConfigClass(element);
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        this.processStringAttribute(element, builder, PARAM_ALGORITHM, PARAM_ALGORITHM);
        this.processIntegerAttribute(element, builder, PARAM_ITERATIONS, PARAM_ITERATIONS);
        this.processIntegerAttribute(element, builder, PARAM_SALT_SIZE_BYTES, "saltSizeBytes");
        this.processBeanAttribute(element, builder, PARAM_SALT_GENERATOR_BEAN, "saltGenerator");
        this.processStringAttribute(element, builder, PARAM_SALT_GENERATOR_CLASS_NAME, "saltGeneratorClassName");
        this.processBeanAttribute(element, builder, PARAM_PROVIDER_BEAN, "provider");
        this.processStringAttribute(element, builder, PARAM_PROVIDER_CLASS_NAME, "providerClassName");
        this.processStringAttribute(element, builder, PARAM_PROVIDER_NAME, "providerName");
        this.processBooleanAttribute(element, builder, PARAM_INVERT_POSITION_OF_SALT_IN_MESSAGE_BEFORE_DIGESTING, "invertPositionOfSaltInMessageBeforeDigesting");
        this.processBooleanAttribute(element, builder, PARAM_INVERT_POSITION_OF_PLAIN_SALT_IN_ENCRYPTION_RESULTS, "invertPositionOfPlainSaltInEncryptionResults");
        this.processBooleanAttribute(element, builder, PARAM_USE_LENIENT_SALT_SIZE_CHECK, "useLenientSaltSizeCheck");
        this.processIntegerAttribute(element, builder, PARAM_POOL_SIZE, "poolSize");
        this.processStringAttribute(element, builder, PARAM_STRING_OUTPUT_TYPE, "stringOutputType");
        this.processStringAttribute(element, builder, PARAM_UNICODE_NORMALIZATION_IGNORED, "unicodeNormalizationIgnored");
        this.processStringAttribute(element, builder, PARAM_PREFIX, PARAM_PREFIX);
        this.processStringAttribute(element, builder, PARAM_SUFFIX, PARAM_SUFFIX);
        this.processStringAttribute(element, builder, PARAM_ALGORITHM_ENV_NAME, "algorithmEnvName");
        this.processStringAttribute(element, builder, PARAM_ITERATIONS_ENV_NAME, "iterationsEnvName");
        this.processStringAttribute(element, builder, PARAM_SALT_SIZE_BYTES_ENV_NAME, "saltSizeBytesEnvName");
        this.processStringAttribute(element, builder, PARAM_SALT_GENERATOR_CLASS_NAME_ENV_NAME, "saltGeneratorClassNameEnvName");
        this.processStringAttribute(element, builder, PARAM_PROVIDER_CLASS_NAME_ENV_NAME, "providerClassNameEnvName");
        this.processStringAttribute(element, builder, PARAM_PROVIDER_NAME_ENV_NAME, "providerNameEnvName");
        this.processStringAttribute(element, builder, PARAM_INVERT_POSITION_OF_SALT_IN_MESSAGE_BEFORE_DIGESTING_ENV_NAME, "invertPositionOfSaltInMessageBeforeDigestingEnvName");
        this.processStringAttribute(element, builder, PARAM_INVERT_POSITION_OF_PLAIN_SALT_IN_ENCRYPTION_RESULTS_ENV_NAME, "invertPositionOfPlainSaltInEncryptionResultsEnvName");
        this.processStringAttribute(element, builder, PARAM_USE_LENIENT_SALT_SIZE_CHECK_ENV_NAME, "useLenientSaltSizeCheckEnvName");
        this.processStringAttribute(element, builder, PARAM_POOL_SIZE_ENV_NAME, "poolSizeEnvName");
        this.processStringAttribute(element, builder, PARAM_ALGORITHM_SYS_PROPERTY_NAME, "algorithmSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_ITERATIONS_SYS_PROPERTY_NAME, "iterationsSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_SALT_SIZE_BYTES_SYS_PROPERTY_NAME, "saltSizeBytesSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_SALT_GENERATOR_CLASS_NAME_SYS_PROPERTY_NAME, "saltGeneratorClassNameSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_PROVIDER_CLASS_NAME_SYS_PROPERTY_NAME, "providerClassNameSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_PROVIDER_NAME_SYS_PROPERTY_NAME, "providerNameSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_INVERT_POSITION_OF_SALT_IN_MESSAGE_BEFORE_DIGESTING_SYS_PROPERTY_NAME, "invertPositionOfSaltInMessageBeforeDigestingSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_INVERT_POSITION_OF_PLAIN_SALT_IN_ENCRYPTION_RESULTS_SYS_PROPERTY_NAME, "invertPositionOfPlainSaltInEncryptionResultsSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_USE_LENIENT_SALT_SIZE_CHECK_SYS_PROPERTY_NAME, "useLenientSaltSizeCheckSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_POOL_SIZE_SYS_PROPERTY_NAME, "poolSizeSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_STRING_OUTPUT_TYPE_ENV_NAME, "stringOutputTypeEnvName");
        this.processStringAttribute(element, builder, PARAM_STRING_OUTPUT_TYPE_SYS_PROPERTY_NAME, "stringOutputTypeSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_UNICODE_NORMALIZATION_IGNORED_ENV_NAME, "unicodeNormalizationIgnoredEnvName");
        this.processStringAttribute(element, builder, PARAM_UNICODE_NORMALIZATION_IGNORED_SYS_PROPERTY_NAME, "unicodeNormalizationIgnoredSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_PREFIX_ENV_NAME, "prefixEnvName");
        this.processStringAttribute(element, builder, PARAM_PREFIX_SYS_PROPERTY_NAME, "prefixSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_SUFFIX_ENV_NAME, "suffixEnvName");
        this.processStringAttribute(element, builder, PARAM_SUFFIX_SYS_PROPERTY_NAME, "suffixSysPropertyName");
        String scope = element.getAttribute(SCOPE_ATTRIBUTE);
        if (StringUtils.hasLength((String)scope)) {
            builder.setScope(scope);
        }
    }

    private static Class<?> computeConfigClass(Element element) {
        boolean isSimpleConfig = false;
        boolean isStringConfig = false;
        boolean isEnvironmentConfig = false;
        boolean isStringEnvironmentConfig = false;
        NamedNodeMap attributesMap = element.getAttributes();
        int attributesLen = attributesMap.getLength();
        for (int i = 0; i < attributesLen; ++i) {
            Node attribute = attributesMap.item(i);
            String attributeName = attribute.getNodeName();
            if (!isSimpleConfig && PARAMS_SIMPLE.contains(attributeName)) {
                isSimpleConfig = true;
            }
            if (!isStringConfig && PARAMS_STRING.contains(attributeName)) {
                isStringConfig = true;
            }
            if (!isEnvironmentConfig && PARAMS_ENVIRONMENT.contains(attributeName)) {
                isEnvironmentConfig = true;
            }
            if (isStringEnvironmentConfig || !PARAMS_STRING_ENVIRONMENT.contains(attributeName)) continue;
            isStringEnvironmentConfig = true;
        }
        if (isStringEnvironmentConfig || isEnvironmentConfig && isStringConfig) {
            return EnvironmentStringDigesterConfig.class;
        }
        if (isEnvironmentConfig) {
            return EnvironmentDigesterConfig.class;
        }
        if (isStringConfig) {
            return SimpleStringDigesterConfig.class;
        }
        return SimpleDigesterConfig.class;
    }
}

