/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.language;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.language.LanguageProducer;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;

@UriEndpoint(scheme="language")
public class LanguageEndpoint
extends ResourceEndpoint {
    private Language language;
    private Expression expression;
    @UriParam
    private String languageName;
    @UriParam
    private String script;
    @UriParam
    private boolean transform = true;
    @UriParam
    private boolean contentResolvedFromResource;
    @UriParam
    private boolean cacheScript;

    public LanguageEndpoint() {
        this.setContentCache(true);
    }

    public LanguageEndpoint(String endpointUri, Component component, Language language, Expression expression, String resourceUri) {
        super(endpointUri, component, resourceUri);
        this.language = language;
        this.expression = expression;
        this.setContentCache(true);
    }

    @Override
    public Producer createProducer() throws Exception {
        ObjectHelper.notNull(this.getCamelContext(), "CamelContext", this);
        if (this.language == null && this.languageName != null) {
            this.language = this.getCamelContext().resolveLanguage(this.languageName);
        }
        ObjectHelper.notNull(this.language, "language", this);
        if (this.cacheScript && this.expression == null && this.script != null) {
            this.script = this.resolveScript(this.script);
            this.expression = this.language.createExpression(this.script);
        }
        return new LanguageProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new RuntimeCamelException("Cannot consume to a LanguageEndpoint: " + this.getEndpointUri());
    }

    protected String resolveScript(String script) throws IOException {
        String answer;
        if (ResourceHelper.hasScheme(script)) {
            InputStream is = this.loadResource(script);
            answer = this.getCamelContext().getTypeConverter().convertTo(String.class, is);
            IOHelper.close((Closeable)is);
        } else {
            answer = script;
        }
        return answer;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    protected String createEndpointUri() {
        String s = this.script;
        try {
            s = URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.languageName + ":" + s;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Expression getExpression() {
        if (this.isContentResolvedFromResource() && this.isContentCacheCleared()) {
            return null;
        }
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public boolean isTransform() {
        return this.transform;
    }

    public void setTransform(boolean transform) {
        this.transform = transform;
    }

    public void setLanguageName(String languageName) {
        this.languageName = languageName;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public boolean isContentResolvedFromResource() {
        return this.contentResolvedFromResource;
    }

    public void setContentResolvedFromResource(boolean contentResolvedFromResource) {
        this.contentResolvedFromResource = contentResolvedFromResource;
    }

    public boolean isCacheScript() {
        return this.cacheScript;
    }

    public void setCacheScript(boolean cacheScript) {
        this.cacheScript = cacheScript;
    }

    @Override
    public void clearContentCache() {
        super.clearContentCache();
        this.expression = null;
        this.script = null;
    }
}

