/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.processor.WrapProcessor;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TransactedPolicy;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="policy")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PolicyDefinition
extends OutputDefinition<PolicyDefinition> {
    @XmlTransient
    protected Class<? extends Policy> type;
    @XmlAttribute(required=true)
    protected String ref;
    @XmlTransient
    private Policy policy;

    public PolicyDefinition() {
    }

    public PolicyDefinition(Policy policy) {
        this.policy = policy;
    }

    @Override
    public String toString() {
        return "Policy[" + this.description() + "]";
    }

    protected String description() {
        if (this.policy != null) {
            return this.policy.toString();
        }
        return "ref:" + this.ref;
    }

    @Override
    public String getShortName() {
        boolean transacted = this.type != null && this.type.isAssignableFrom(TransactedPolicy.class);
        return transacted ? "transacted" : "policy";
    }

    @Override
    public String getLabel() {
        return this.getShortName() + "[" + this.getDescription() + "]";
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isTopLevelOnly() {
        return false;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public void setType(Class<? extends Policy> type) {
        this.type = type;
    }

    public PolicyDefinition ref(String ref) {
        this.setRef(ref);
        return this;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Policy policy = this.resolvePolicy(routeContext);
        ObjectHelper.notNull(policy, "policy", this);
        policy.beforeWrap(routeContext, this);
        Processor childProcessor = this.createChildProcessor(routeContext, true);
        Processor target = policy.wrap(routeContext, childProcessor);
        if (!(target instanceof Service)) {
            target = new WrapProcessor(target, childProcessor);
        }
        return target;
    }

    protected Policy resolvePolicy(RouteContext routeContext) {
        if (this.policy != null) {
            return this.policy;
        }
        return TransactedDefinition.doResolvePolicy(routeContext, this.getRef(), this.type);
    }
}

