/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.component.cache.CacheConfiguration;
import org.apache.camel.component.cache.CacheEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(CacheProducer.class);
    private CacheConfiguration config;
    private Ehcache cache;

    public CacheProducer(CacheEndpoint endpoint, CacheConfiguration config) throws Exception {
        super((Endpoint)endpoint);
        this.config = config;
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    public CacheEndpoint getEndpoint() {
        return (CacheEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        LOG.trace("Cache Name: {}", (Object)this.config.getCacheName());
        this.cache = this.getEndpoint().initializeCache();
        Map headers = exchange.getIn().getHeaders();
        String key = headers.containsKey("CamelCacheKey") ? (String)exchange.getIn().getHeader("CamelCacheKey", String.class) : this.getEndpoint().getKey();
        String string = operation = headers.containsKey("CamelCacheOperation") ? (String)headers.get("CamelCacheOperation") : this.getEndpoint().getOperation();
        if (operation == null) {
            throw new CacheException("CamelCacheOperation header not specified in message");
        }
        if (key == null && !this.checkIsEqual(operation, "CamelCacheDeleteAll")) {
            throw new CacheException("CamelCacheKey is not specified in message header or endpoint URL.");
        }
        this.performCacheOperation(exchange, operation, key);
        exchange.getIn().removeHeader("CamelCacheKey");
        exchange.getIn().removeHeader("CamelCacheOperation");
    }

    private void performCacheOperation(Exchange exchange, String operation, String key) throws Exception {
        if (this.checkIsEqual(operation, "Add")) {
            LOG.debug("Adding an element with key {} into the Cache", (Object)key);
            Element element = this.createElementFromBody(key, exchange, "CamelCacheAdd");
            this.cache.put(element);
        } else if (this.checkIsEqual(operation, "Update")) {
            LOG.debug("Updating an element with key {} into the Cache", (Object)key);
            Element element = this.createElementFromBody(key, exchange, "CamelCacheUpdate");
            this.cache.put(element);
        } else if (this.checkIsEqual(operation, "DeleteAll")) {
            LOG.debug("Deleting All elements from the Cache");
            this.cache.removeAll();
        } else if (this.checkIsEqual(operation, "Delete")) {
            LOG.debug("Deleting an element with key {} into the Cache", (Object)key);
            this.cache.remove((Serializable)((Object)key));
        } else if (this.checkIsEqual(operation, "Get")) {
            LOG.debug("Quering an element with key {} from the Cache", (Object)key);
            if (this.cache.get((Serializable)((Object)key)) != null) {
                exchange.getIn().setHeader("CamelCacheElementWasFound", (Object)true);
                exchange.getIn().setBody((Object)this.cache.get((Serializable)((Object)key)).getValue());
            } else {
                exchange.getIn().removeHeader("CamelCacheElementWasFound");
            }
        } else if (this.checkIsEqual(operation, "Check")) {
            LOG.debug("Querying an element with key {} from the Cache", (Object)key);
            if (this.cache.isKeyInCache((Object)key)) {
                exchange.getIn().setHeader("CamelCacheElementWasFound", (Object)true);
            } else {
                exchange.getIn().removeHeader("CamelCacheElementWasFound");
            }
        } else {
            throw new CacheException("CamelCacheOperation " + operation + " is not supported.");
        }
    }

    private boolean checkIsEqual(String operation, String constant) {
        return operation.equalsIgnoreCase(constant) || operation.equalsIgnoreCase("CamelCache" + constant);
    }

    private Element createElementFromBody(String key, Exchange exchange, String cacheOperation) throws NoTypeConversionAvailableException {
        Boolean flag;
        Integer idle;
        Element element;
        Object body = exchange.getIn().getBody();
        if (body == null) {
            throw new CacheException("Body cannot be null for operation " + cacheOperation);
        }
        if (body instanceof Serializable) {
            element = new Element((Object)key, body);
        } else {
            InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, body);
            element = new Element((Serializable)((Object)key), (Serializable)exchange.getContext().getTypeConverter().mandatoryConvertTo(byte[].class, (Object)is));
        }
        Integer ttl = (Integer)exchange.getIn().getHeader("CamelCacheTimeToLive", Integer.class);
        if (ttl != null) {
            element.setTimeToLive(ttl.intValue());
        }
        if ((idle = (Integer)exchange.getIn().getHeader("CamelCacheTimeToIdle", Integer.class)) != null) {
            element.setTimeToIdle(idle.intValue());
        }
        if ((flag = (Boolean)exchange.getIn().getHeader("CamelCacheEternal", Boolean.class)) != null) {
            element.setEternal(flag.booleanValue());
        }
        return element;
    }
}

