/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.krati;

import java.io.IOException;
import krati.store.DataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KratiDataStoreRegistration {
    private static final transient Logger LOG = LoggerFactory.getLogger(KratiDataStoreRegistration.class);
    private final DataStore<Object, Object> dataStore;
    private int registrationCount;

    public KratiDataStoreRegistration(DataStore<Object, Object> dataStore) {
        this.dataStore = dataStore;
    }

    public int register() {
        return ++this.registrationCount;
    }

    public boolean unregister() {
        if (--this.registrationCount <= 0) {
            try {
                this.dataStore.close();
            }
            catch (IOException e) {
                LOG.warn("Error while closing datastore.", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    public DataStore<Object, Object> getDataStore() {
        this.register();
        return this.dataStore;
    }
}

