/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.soap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.converter.jaxb.JaxbDataFormat;
import org.apache.camel.dataformat.soap.Soap11DataFormatAdapter;
import org.apache.camel.dataformat.soap.Soap12DataFormatAdapter;
import org.apache.camel.dataformat.soap.SoapDataFormatAdapter;
import org.apache.camel.dataformat.soap.name.ElementNameStrategy;
import org.apache.camel.dataformat.soap.name.ServiceInterfaceStrategy;
import org.apache.camel.dataformat.soap.name.TypeNameStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapJaxbDataFormat
extends JaxbDataFormat {
    public static final String SOAP_UNMARSHALLED_HEADER_LIST = "org.apache.camel.dataformat.soap.UNMARSHALLED_HEADER_LIST";
    private static final transient Logger LOG = LoggerFactory.getLogger(SoapJaxbDataFormat.class);
    private SoapDataFormatAdapter adapter;
    private ElementNameStrategy elementNameStrategy;
    private String elementNameStrategyRef;
    private boolean ignoreUnmarshalledHeaders;
    private String version;

    public SoapJaxbDataFormat() {
    }

    public SoapJaxbDataFormat(String contextPath) {
        super(contextPath);
    }

    public SoapJaxbDataFormat(String contextPath, ElementNameStrategy elementNameStrategy) {
        this(contextPath);
        this.elementNameStrategy = elementNameStrategy;
    }

    public SoapJaxbDataFormat(String contextPath, String elementNameStrategyRef) {
        this(contextPath);
        this.elementNameStrategyRef = elementNameStrategyRef;
    }

    protected void doStart() throws Exception {
        if ("1.2".equals(this.version)) {
            LOG.debug("Using SOAP 1.2 adapter");
            this.adapter = new Soap12DataFormatAdapter(this);
        } else {
            LOG.debug("Using SOAP 1.1 adapter");
            this.adapter = new Soap11DataFormatAdapter(this);
        }
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkElementNameStrategy(Exchange exchange) {
        if (this.elementNameStrategy == null) {
            SoapJaxbDataFormat soapJaxbDataFormat = this;
            synchronized (soapJaxbDataFormat) {
                if (this.elementNameStrategy != null) {
                    return;
                }
                this.elementNameStrategy = this.elementNameStrategyRef != null ? (ElementNameStrategy)exchange.getContext().getRegistry().lookup(this.elementNameStrategyRef, ElementNameStrategy.class) : new TypeNameStrategy();
            }
        }
    }

    public void marshal(Exchange exchange, Object inputObject, OutputStream stream) throws IOException {
        BeanInvocation beanInvocation;
        WebMethod webMethod;
        this.checkElementNameStrategy(exchange);
        String soapAction = this.getSoapActionFromExchange(exchange);
        if (soapAction == null && inputObject instanceof BeanInvocation && (webMethod = (beanInvocation = (BeanInvocation)inputObject).getMethod().getAnnotation(WebMethod.class)) != null && webMethod.action() != null) {
            soapAction = webMethod.action();
        }
        Object envelope = this.adapter.doMarshal(exchange, inputObject, stream, soapAction);
        super.marshal(exchange, envelope, stream);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<JAXBElement<?>> createContentFromObject(Object inputObject, String soapAction, List<JAXBElement<?>> headerElements) {
        ArrayList<Object> bodyParts = new ArrayList<Object>();
        ArrayList<Object> headerParts = new ArrayList<Object>();
        if (inputObject instanceof BeanInvocation) {
            BeanInvocation bi = (BeanInvocation)inputObject;
            Annotation[][] annotations = bi.getMethod().getParameterAnnotations();
            ArrayList<WebParam> arrayList = new ArrayList<WebParam>();
            Annotation[][] arr$ = annotations;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Annotation[] annotationArray;
                for (Annotation annotation : annotationArray = arr$[i$]) {
                    if (!(annotation instanceof WebParam)) continue;
                    arrayList.add((WebParam)annotation);
                }
            }
            if (arrayList.size() > 0) {
                void var12_23;
                if (arrayList.size() != bi.getArgs().length) throw new RuntimeCamelException("The number of bean invocation parameters does not match the number of parameters annotated with @WebParam for the method [ " + bi.getMethod().getName() + "].");
                int index = -1;
                Object[] arr$2 = bi.getArgs();
                int len$2 = arr$2.length;
                boolean bl = false;
                while (var12_23 < len$2) {
                    Object o = arr$2[var12_23];
                    if (((WebParam)arrayList.get(++index)).header()) {
                        headerParts.add(o);
                    } else {
                        bodyParts.add(o);
                    }
                    ++var12_23;
                }
            } else {
                for (Annotation[] annotationArray : bi.getArgs()) {
                    bodyParts.add(annotationArray);
                }
            }
        } else {
            bodyParts.add(inputObject);
        }
        ArrayList bodyElements = new ArrayList();
        for (Object e : bodyParts) {
            QName name = this.elementNameStrategy.findQNameForSoapActionOrType(soapAction, e.getClass());
            if (name == null) {
                LOG.warn("Could not find QName for class " + e.getClass().getName());
                continue;
            }
            bodyElements.add(this.getElement(e, name));
        }
        for (Object e : headerParts) {
            QName name = this.elementNameStrategy.findQNameForSoapActionOrType(soapAction, e.getClass());
            if (name == null) {
                LOG.warn("Could not find QName for class " + e.getClass().getName());
                continue;
            }
            JAXBElement<?> headerElem = this.getElement(e, name);
            if (null == headerElem) continue;
            headerElements.add(headerElem);
        }
        return bodyElements;
    }

    private JAXBElement<?> getElement(Object fromObj, QName name) {
        Object value = null;
        if (fromObj instanceof Holder) {
            Holder holder = (Holder)fromObj;
            value = holder.value;
            if (null == value) {
                return null;
            }
        } else {
            value = fromObj;
        }
        return new JAXBElement(name, value.getClass(), value);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws IOException {
        this.checkElementNameStrategy(exchange);
        String soapAction = this.getSoapActionFromExchange(exchange);
        if (soapAction != null && this.elementNameStrategy instanceof ServiceInterfaceStrategy) {
            ServiceInterfaceStrategy strategy = (ServiceInterfaceStrategy)this.elementNameStrategy;
            String methodName = strategy.getMethodForSoapAction(soapAction);
            exchange.getOut().setHeader("CamelBeanMethodName", (Object)methodName);
        }
        if (soapAction != null) {
            exchange.setProperty("CamelSoapAction", (Object)soapAction);
        }
        Object unmarshalledObject = super.unmarshal(exchange, stream);
        Object rootObject = JAXBIntrospector.getValue((Object)unmarshalledObject);
        return this.adapter.doUnmarshal(exchange, stream, rootObject);
    }

    private String getSoapActionFromExchange(Exchange exchange) {
        Message inMessage = exchange.getIn();
        String soapAction = (String)inMessage.getHeader("CamelSoapAction", String.class);
        if (soapAction == null && (soapAction = (String)inMessage.getHeader("SOAPAction", String.class)) != null && soapAction.startsWith("\"")) {
            soapAction = soapAction.substring(1, soapAction.length() - 1);
        }
        if (soapAction == null) {
            soapAction = (String)exchange.getProperty("CamelSoapAction", String.class);
        }
        return soapAction;
    }

    protected JAXBContext createContext() throws JAXBException {
        if (this.getContextPath() != null) {
            return JAXBContext.newInstance((String)(this.adapter.getSoapPackageName() + ":" + this.getContextPath()));
        }
        return JAXBContext.newInstance((Class[])new Class[0]);
    }

    public ElementNameStrategy getElementNameStrategy() {
        return this.elementNameStrategy;
    }

    public void setElementNameStrategy(Object nameStrategy) {
        if (nameStrategy == null) {
            this.elementNameStrategy = null;
        } else if (nameStrategy instanceof ElementNameStrategy) {
            this.elementNameStrategy = (ElementNameStrategy)nameStrategy;
        } else {
            throw new IllegalArgumentException("The argument for setElementNameStrategy should be subClass of " + ElementNameStrategy.class.getName());
        }
    }

    public String getElementNameStrategyRef() {
        return this.elementNameStrategyRef;
    }

    public void setElementNameStrategyRef(String elementNameStrategyRef) {
        this.elementNameStrategyRef = elementNameStrategyRef;
    }

    public boolean isIgnoreUnmarshalledHeaders() {
        return this.ignoreUnmarshalledHeaders;
    }

    public void setIgnoreUnmarshalledHeaders(boolean ignoreUnmarshalledHeaders) {
        this.ignoreUnmarshalledHeaders = ignoreUnmarshalledHeaders;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

