/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cometd;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cometd.CometdComponent;
import org.apache.camel.component.cometd.CometdConsumer;
import org.apache.camel.component.cometd.CometdProducer;
import org.apache.camel.component.cometd.CometdProducerConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

public class CometdEndpoint
extends DefaultEndpoint {
    private String baseResource;
    private int timeout = 240000;
    private int interval;
    private int maxInterval = 30000;
    private int multiFrameInterval = 1500;
    private boolean jsonCommented = true;
    private boolean sessionHeadersEnabled;
    private int logLevel = 1;
    private URI uri;
    private CometdComponent component;
    private boolean crossOriginFilterOn;
    private String allowedOrigins;
    private String filterPath;

    public CometdEndpoint(CometdComponent component, String uri, String remaining, Map<String, Object> parameters) {
        super(uri, (Component)component);
        this.component = component;
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)((Object)this.component), (String)"component");
        CometdProducer producer = new CometdProducer(this);
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)((Object)this.component), (String)"component");
        CometdConsumer consumer = new CometdConsumer(this, processor);
        return consumer;
    }

    public void connect(CometdProducerConsumer prodcons) throws Exception {
        this.component.connect(prodcons);
    }

    public void disconnect(CometdProducerConsumer prodcons) throws Exception {
        this.component.disconnect(prodcons);
    }

    public CometdComponent getComponent() {
        return this.component;
    }

    public boolean isSingleton() {
        return false;
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public int getPort() {
        if (this.uri.getPort() == -1) {
            if ("cometds".equals(this.getProtocol())) {
                return 443;
            }
            return 80;
        }
        return this.uri.getPort();
    }

    public String getProtocol() {
        return this.uri.getScheme();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getBaseResource() {
        return this.baseResource;
    }

    public void setBaseResource(String baseResource) {
        this.baseResource = baseResource;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public int getMaxInterval() {
        return this.maxInterval;
    }

    public void setMaxInterval(int maxInterval) {
        this.maxInterval = maxInterval;
    }

    public int getMultiFrameInterval() {
        return this.multiFrameInterval;
    }

    public void setMultiFrameInterval(int multiFrameInterval) {
        this.multiFrameInterval = multiFrameInterval;
    }

    public boolean isJsonCommented() {
        return this.jsonCommented;
    }

    public void setJsonCommented(boolean commented) {
        this.jsonCommented = commented;
    }

    public void setSessionHeadersEnabled(boolean enable) {
        this.sessionHeadersEnabled = enable;
    }

    public boolean areSessionHeadersEnabled() {
        return this.sessionHeadersEnabled;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public String getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(String allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public boolean isCrossOriginFilterOn() {
        return this.crossOriginFilterOn;
    }

    public void setCrossOriginFilterOn(boolean crossOriginFilterOn) {
        this.crossOriginFilterOn = crossOriginFilterOn;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public void setFilterPath(String filterPath) {
        this.filterPath = filterPath;
    }
}

