/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina2;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.camel.CamelContext;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

public class Mina2UdpProtocolCodecFactory
implements ProtocolCodecFactory {
    private final Charset charset;
    private final CamelContext context;

    public Mina2UdpProtocolCodecFactory(CamelContext context, Charset charset) {
        this.context = context;
        this.charset = charset;
    }

    public ProtocolEncoder getEncoder(IoSession session) throws Exception {
        return new ProtocolEncoder(){
            private CharsetEncoder encoder;

            public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
                if (this.encoder == null) {
                    this.encoder = Mina2UdpProtocolCodecFactory.this.charset.newEncoder();
                }
                IoBuffer buf = Mina2UdpProtocolCodecFactory.this.toIoBuffer(message, this.encoder);
                buf.flip();
                out.write((Object)buf);
            }

            public void dispose(IoSession session) throws Exception {
            }
        };
    }

    public ProtocolDecoder getDecoder(IoSession session) throws Exception {
        return new ProtocolDecoder(){

            public void decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
                byte[] bytes = (byte[])Mina2UdpProtocolCodecFactory.this.context.getTypeConverter().convertTo(byte[].class, (Object)in);
                out.write((Object)bytes);
            }

            public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
            }

            public void dispose(IoSession session) throws Exception {
            }
        };
    }

    private IoBuffer toIoBuffer(Object message, CharsetEncoder encoder) throws CharacterCodingException, NoTypeConversionAvailableException {
        String value = (String)this.context.getTypeConverter().convertTo(String.class, message);
        if (value != null) {
            IoBuffer answer = IoBuffer.allocate((int)value.length()).setAutoExpand(true);
            answer.putString((CharSequence)value, encoder);
            return answer;
        }
        return (IoBuffer)this.context.getTypeConverter().mandatoryConvertTo(IoBuffer.class, message);
    }
}

