/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.twitter.TwitterConfiguration;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.TwitterEndpointDirect;
import org.apache.camel.component.twitter.TwitterEndpointEvent;
import org.apache.camel.component.twitter.TwitterEndpointPolling;
import org.apache.camel.component.twitter.data.EndpointType;
import org.apache.camel.impl.DefaultComponent;

public class TwitterComponent
extends DefaultComponent {
    private String consumerKey;
    private String consumerSecret;
    private String accessToken;
    private String accessTokenSecret;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        TwitterEndpoint endpoint;
        TwitterConfiguration properties = new TwitterConfiguration();
        properties.setConsumerKey(this.consumerKey);
        properties.setConsumerSecret(this.consumerSecret);
        properties.setAccessToken(this.accessToken);
        properties.setAccessTokenSecret(this.accessTokenSecret);
        this.setProperties(properties, parameters);
        switch (EndpointType.fromUri(properties.getType())) {
            case POLLING: {
                endpoint = new TwitterEndpointPolling(uri, this, properties);
                break;
            }
            case EVENT: {
                endpoint = new TwitterEndpointEvent(uri, this, properties);
                break;
            }
            default: {
                endpoint = new TwitterEndpointDirect(uri, this, properties);
            }
        }
        return endpoint;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }
}

