/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.guice;

import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.internal.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.guice.CamelModule;

public class CamelModuleWithRouteTypes
extends CamelModule {
    private Set<Class<? extends RoutesBuilder>> routes;

    public CamelModuleWithRouteTypes(Class<? extends RoutesBuilder> ... routeTypes) {
        this.routes = new HashSet<Class<? extends RoutesBuilder>>();
        for (Class<? extends RoutesBuilder> route : routeTypes) {
            this.routes.add(route);
        }
    }

    public CamelModuleWithRouteTypes(Set<Class<? extends RoutesBuilder>> routes) {
        this.routes = routes;
    }

    @Provides
    Set<RoutesBuilder> routes(Injector injector) {
        HashSet answer = Sets.newHashSet();
        for (Class<? extends RoutesBuilder> type : this.routes) {
            RoutesBuilder route = (RoutesBuilder)injector.getInstance(type);
            answer.add(route);
        }
        return answer;
    }
}

