/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.testng;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.test.ExcludingPackageScanClassResolver;
import org.apache.camel.testng.CamelTestSupport;
import org.apache.camel.util.CastUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;

public abstract class CamelSpringTestSupport
extends CamelTestSupport {
    protected static ThreadLocal<AbstractApplicationContext> threadAppContext = new ThreadLocal();
    protected static Object lock = new Object();
    protected static AbstractApplicationContext applicationContext;

    protected abstract AbstractApplicationContext createApplicationContext();

    @Override
    public void postProcessTest() throws Exception {
        super.postProcessTest();
        if (this.isCreateCamelContextPerClass()) {
            applicationContext = threadAppContext.get();
        }
        CamelBeanPostProcessor processor = new CamelBeanPostProcessor();
        processor.setApplicationContext((ApplicationContext)applicationContext);
        processor.setCamelContext((CamelContext)this.context);
        processor.postProcessBeforeInitialization((Object)this, ((Object)((Object)this)).getClass().getName());
        processor.postProcessAfterInitialization((Object)this, ((Object)((Object)this)).getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPreSetup() throws Exception {
        if (!"true".equalsIgnoreCase(System.getProperty("skipStartingCamelContext"))) {
            Object object = lock;
            synchronized (object) {
                SpringCamelContext.setNoStart((boolean)true);
                if (this.isCreateCamelContextPerClass()) {
                    applicationContext = threadAppContext.get();
                    if (applicationContext == null) {
                        applicationContext = this.createApplicationContext();
                        threadAppContext.set(applicationContext);
                    }
                } else {
                    applicationContext = this.createApplicationContext();
                }
                CamelSpringTestSupport.assertNotNull((Object)applicationContext, (String)"Should have created a valid spring context");
                SpringCamelContext.setNoStart((boolean)false);
            }
        } else {
            this.log.info("Skipping starting CamelContext as system property skipStartingCamelContext is set to be true.");
        }
    }

    @Override
    @AfterMethod
    public void tearDown() throws Exception {
        super.tearDown();
        if (!this.isCreateCamelContextPerClass() && applicationContext != null) {
            applicationContext.destroy();
            applicationContext = null;
        }
    }

    @AfterClass
    public static void tearSpringDownAfterClass() throws Exception {
        if (threadAppContext.get() != null) {
            threadAppContext.get().destroy();
            threadAppContext.remove();
        }
    }

    protected ApplicationContext getRouteExcludingApplicationContext() {
        GenericApplicationContext routeExcludingContext = new GenericApplicationContext();
        routeExcludingContext.registerBeanDefinition("excludingResolver", (BeanDefinition)new RootBeanDefinition(ExcludingPackageScanClassResolver.class));
        routeExcludingContext.refresh();
        ExcludingPackageScanClassResolver excludingResolver = (ExcludingPackageScanClassResolver)routeExcludingContext.getBean("excludingResolver", ExcludingPackageScanClassResolver.class);
        List excluded = CastUtils.cast(Arrays.asList(this.excludeRoutes()));
        excludingResolver.setExcludedClasses(new HashSet(excluded));
        return routeExcludingContext;
    }

    protected Class<?>[] excludeRoutes() {
        Class[] classArray;
        Class<?> excludedRoute = this.excludeRoute();
        if (excludedRoute != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = excludedRoute;
        } else {
            classArray = new Class[]{};
        }
        return classArray;
    }

    protected Class<?> excludeRoute() {
        return null;
    }

    public <T> T getMandatoryBean(Class<T> type, String name) {
        return (T)applicationContext.getBean(name, type);
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        return SpringCamelContext.springCamelContext((ApplicationContext)applicationContext, (boolean)false);
    }
}

