/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="camel", name="context-list", description="Lists all Camel contexts.")
public class ContextList
extends OsgiCommandSupport {
    private static final String NAME_COLUMN_LABEL = "Name";
    private static final String STATUS_COLUMN_LABEL = "Status";
    private static final String UPTIME_COLUMN_LABEL = "Uptime";
    private static final int DEFAULT_FORMAT_BUFFER_LENGTH = 24;
    private static final String DEFAULT_FIELD_PREAMBLE = "[ ";
    private static final String DEFAULT_FIELD_POSTAMBLE = " ]";
    private static final String DEFAULT_HEADER_PREAMBLE = "  ";
    private static final String DEFAULT_HEADER_POSTAMBLE = "  ";
    private static final int DEFAULT_COLUMN_WIDTH_INCREMENT = 0;
    private static final int MAX_COLUMN_WIDTH = Integer.MAX_VALUE;
    private CamelController camelController;

    public void setCamelController(CamelController camelController) {
        this.camelController = camelController;
    }

    protected Object doExecute() throws Exception {
        List<CamelContext> camelContexts = this.camelController.getCamelContexts();
        Map<String, Integer> columnWidths = ContextList.computeColumnWidths(camelContexts);
        String headerFormat = ContextList.buildFormatString(columnWidths, true);
        String rowFormat = ContextList.buildFormatString(columnWidths, false);
        PrintStream out = System.out;
        if (camelContexts.size() > 0) {
            out.println(String.format(headerFormat, NAME_COLUMN_LABEL, STATUS_COLUMN_LABEL, UPTIME_COLUMN_LABEL));
            for (CamelContext camelContext : camelContexts) {
                out.println(String.format(rowFormat, camelContext.getName(), camelContext.getStatus(), camelContext.getUptime()));
            }
        }
        return null;
    }

    private static Map<String, Integer> computeColumnWidths(Iterable<CamelContext> camelContexts) throws Exception {
        if (camelContexts == null) {
            throw new IllegalArgumentException("unable to determine column widths from null Iterable<CamelContext>");
        }
        int maxNameLen = 0;
        int maxStatusLen = 0;
        int maxUptimeLen = 0;
        for (CamelContext camelContext : camelContexts) {
            String name = camelContext.getName();
            maxNameLen = Math.max(maxNameLen, name == null ? 0 : name.length());
            String status = camelContext.getStatus().toString();
            maxStatusLen = Math.max(maxStatusLen, status == null ? 0 : status.length());
            String uptime = camelContext.getUptime();
            maxUptimeLen = Math.max(maxUptimeLen, uptime == null ? 0 : uptime.length());
        }
        Hashtable<String, Integer> retval = new Hashtable<String, Integer>(3);
        retval.put(NAME_COLUMN_LABEL, maxNameLen);
        retval.put(STATUS_COLUMN_LABEL, maxStatusLen);
        retval.put(UPTIME_COLUMN_LABEL, maxUptimeLen);
        return retval;
    }

    private static String buildFormatString(Map<String, Integer> columnWidths, boolean isHeader) {
        String fieldPostamble;
        String fieldPreamble;
        if (isHeader) {
            fieldPreamble = "  ";
            fieldPostamble = "  ";
        } else {
            fieldPreamble = DEFAULT_FIELD_PREAMBLE;
            fieldPostamble = DEFAULT_FIELD_POSTAMBLE;
        }
        int columnWidthIncrement = 0;
        int nameLen = Math.min(columnWidths.get(NAME_COLUMN_LABEL) + columnWidthIncrement, Integer.MAX_VALUE);
        int statusLen = Math.min(columnWidths.get(STATUS_COLUMN_LABEL) + columnWidthIncrement, Integer.MAX_VALUE);
        int uptimeLen = Math.min(columnWidths.get(UPTIME_COLUMN_LABEL) + columnWidthIncrement, Integer.MAX_VALUE);
        StringBuilder retval = new StringBuilder(24);
        retval.append(fieldPreamble).append("%-").append(nameLen).append('.').append(nameLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(statusLen).append('.').append(statusLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(uptimeLen).append('.').append(uptimeLen).append('s').append(fieldPostamble).append(' ');
        return retval.toString();
    }
}

