/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.avro;

import java.net.URI;
import java.util.Map;
import org.apache.avro.Protocol;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.avro.AvroComponent;

public class AvroConfiguration
implements Cloneable {
    private String host;
    private int port;
    private Protocol protocol;
    private String protocolLocation;
    private String protocolClassName;
    private String transport;

    public AvroConfiguration copy() {
        try {
            AvroConfiguration answer = (AvroConfiguration)this.clone();
            return answer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void parseURI(URI uri, Map<String, Object> parameters, AvroComponent component) throws Exception {
        this.transport = uri.getScheme();
        if (!this.transport.equalsIgnoreCase("http") && !this.transport.equalsIgnoreCase("netty")) {
            throw new IllegalArgumentException("Unrecognized Avro IPC transport: " + this.protocol + " for uri: " + uri);
        }
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public String getProtocolLocation() {
        return this.protocolLocation;
    }

    public void setProtocolLocation(String protocolLocation) {
        this.protocolLocation = protocolLocation;
    }

    public String getProtocolClassName() {
        return this.protocolClassName;
    }

    public void setProtocolClassName(String protocolClassName) {
        this.protocolClassName = protocolClassName;
    }
}

