/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.component.http4.HttpBinding;
import org.apache.camel.component.http4.HttpEndpoint;
import org.apache.camel.component.http4.HttpHeaderFilterStrategy;
import org.apache.camel.component.http4.HttpMessage;
import org.apache.camel.component.http4.helper.CamelFileDataSource;
import org.apache.camel.component.http4.helper.HttpHelper;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.GZIPHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpBinding
implements HttpBinding {
    private static final transient Logger LOG = LoggerFactory.getLogger(DefaultHttpBinding.class);
    private boolean useReaderForPayload;
    private HeaderFilterStrategy headerFilterStrategy = new HttpHeaderFilterStrategy();
    private HttpEndpoint endpoint;

    @Deprecated
    public DefaultHttpBinding() {
    }

    @Deprecated
    public DefaultHttpBinding(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public DefaultHttpBinding(HttpEndpoint endpoint) {
        this.endpoint = endpoint;
        this.headerFilterStrategy = endpoint.getHeaderFilterStrategy();
    }

    @Override
    public void readRequest(HttpServletRequest request, HttpMessage message) {
        message.getBody();
        Map headers = message.getHeaders();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = request.getHeader(name);
            if (name.toLowerCase().equals("content-type")) {
                name = "Content-Type";
            }
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, message.getExchange())) continue;
            HttpHelper.appendHeader(headers, name, value);
        }
        if (request.getCharacterEncoding() != null) {
            headers.put("CamelHttpCharacterEncoding", request.getCharacterEncoding());
            message.getExchange().setProperty("CamelCharsetName", (Object)request.getCharacterEncoding());
        }
        try {
            this.populateRequestParameters(request, message);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Cannot read request parameters due " + e.getMessage(), (Throwable)e);
        }
        Object body = message.getBody();
        if (body instanceof StreamCache) {
            ((StreamCache)body).reset();
        }
        headers.put("CamelHttpMethod", request.getMethod());
        headers.put("CamelHttpQuery", request.getQueryString());
        headers.put("CamelHttpUrl", request.getRequestURL());
        headers.put("CamelHttpUri", request.getRequestURI());
        headers.put("CamelHttpPath", request.getPathInfo());
        headers.put("Content-Type", request.getContentType());
        if (request.getContentType() != null && "application/x-java-serialized-object".equals(request.getContentType())) {
            try {
                InputStream is = (InputStream)this.endpoint.getCamelContext().getTypeConverter().mandatoryConvertTo(InputStream.class, body);
                Object object = HttpHelper.deserializeJavaObjectFromStream(is);
                if (object != null) {
                    message.setBody(object);
                }
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Cannot deserialize body to Java object", (Throwable)e);
            }
        }
        this.populateAttachments(request, message);
    }

    protected void populateRequestParameters(HttpServletRequest request, HttpMessage message) throws Exception {
        Map headers = message.getHeaders();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String[] values = request.getParameterValues(name);
            LOG.trace("HTTP parameter {} = {}", (Object)name, (Object)values);
            if (values == null) continue;
            for (String value : values) {
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, message.getExchange())) continue;
                HttpHelper.appendHeader(headers, name, value);
            }
        }
        if (request.getMethod().equals("POST") && request.getContentType() != null && request.getContentType().startsWith("application/x-www-form-urlencoded")) {
            String body;
            String charset = request.getCharacterEncoding();
            if (charset == null) {
                charset = "UTF-8";
            }
            if (ObjectHelper.isNotEmpty((Object)(body = (String)message.getBody(String.class)))) {
                for (String param : body.split("&")) {
                    String[] pair = param.split("=", 2);
                    if (pair.length == 2) {
                        String name = URLDecoder.decode(pair[0], charset);
                        String value = URLDecoder.decode(pair[1], charset);
                        if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, message.getExchange())) continue;
                        headers.put(name, value);
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid parameter, expected to be a pair but was " + param);
                }
            }
        }
    }

    protected void populateAttachments(HttpServletRequest request, HttpMessage message) {
        Enumeration names = request.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object object = request.getAttribute(name);
            if (!(object instanceof File)) continue;
            String fileName = request.getParameter(name);
            message.addAttachment(fileName, new DataHandler((DataSource)new CamelFileDataSource((File)object, fileName)));
        }
    }

    @Override
    public void writeResponse(Exchange exchange, HttpServletResponse response) throws IOException {
        if (exchange.isFailed()) {
            if (exchange.getException() != null) {
                this.doWriteExceptionResponse(exchange.getException(), response);
            } else {
                this.doWriteFaultResponse(exchange.getOut(), response, exchange);
            }
        } else {
            this.copyProtocolHeaders(exchange.getIn(), exchange.getOut());
            Message out = exchange.getOut();
            if (out != null) {
                this.doWriteResponse(out, response, exchange);
            }
        }
    }

    private void copyProtocolHeaders(Message request, Message response) {
        if (request.getHeader("Content-Encoding") != null) {
            String contentEncoding = (String)request.getHeader("Content-Encoding", String.class);
            response.setHeader("Content-Encoding", (Object)contentEncoding);
        }
        if (this.checkChunked(response, response.getExchange())) {
            response.setHeader("Transfer-Encoding", (Object)"chunked");
        }
    }

    @Override
    public void doWriteExceptionResponse(Throwable exception, HttpServletResponse response) throws IOException {
        response.setStatus(500);
        if (this.endpoint != null && this.endpoint.isTransferException()) {
            HttpHelper.writeObjectToServletResponse((ServletResponse)response, exception);
        } else {
            response.setContentType("text/plain");
            PrintWriter pw = response.getWriter();
            exception.printStackTrace(pw);
            pw.flush();
        }
    }

    @Override
    public void doWriteFaultResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        message.setHeader("CamelHttpResponseCode", (Object)500);
        this.doWriteResponse(message, response, exchange);
    }

    @Override
    public void doWriteResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        if (message.getHeader("CamelHttpResponseCode") != null) {
            int code = (Integer)message.getHeader("CamelHttpResponseCode", Integer.class);
            response.setStatus(code);
        }
        String contentType = MessageHelper.getContentType((Message)message);
        if (MessageHelper.getContentType((Message)message) != null) {
            response.setContentType(contentType);
        }
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Iterator it = ObjectHelper.createIterator(value, null);
            while (it.hasNext()) {
                String headerValue = (String)exchange.getContext().getTypeConverter().convertTo(String.class, it.next());
                if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, exchange)) continue;
                response.addHeader(key, headerValue);
            }
        }
        if (message.getBody() != null) {
            if (GZIPHelper.isGzip((Message)message)) {
                this.doWriteGZIPResponse(message, response, exchange);
            } else {
                this.doWriteDirectResponse(message, response, exchange);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteDirectResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        block9: {
            block10: {
                String contentType = (String)message.getHeader("Content-Type", String.class);
                if (contentType != null && "application/x-java-serialized-object".equals(contentType)) {
                    try {
                        Object object = message.getMandatoryBody(Serializable.class);
                        HttpHelper.writeObjectToServletResponse((ServletResponse)response, object);
                        return;
                    }
                    catch (InvalidPayloadException e) {
                        throw new IOException(e);
                    }
                }
                InputStream is = this.checkChunked(message, exchange) ? (InputStream)message.getBody(InputStream.class) : (InputStream)exchange.getContext().getTypeConverter().tryConvertTo(InputStream.class, message.getBody());
                if (is == null) break block10;
                ServletOutputStream os = response.getOutputStream();
                try {
                    LOG.trace("Writing direct response from source input stream to servlet output stream");
                    IOHelper.copy((InputStream)is, (OutputStream)os);
                }
                catch (Throwable throwable) {
                    IOHelper.close((Closeable[])new Closeable[]{os, is});
                    throw throwable;
                }
                IOHelper.close((Closeable[])new Closeable[]{os, is});
                break block9;
            }
            String data = (String)message.getBody(String.class);
            if (data != null) {
                LOG.debug("Cannot write from source input stream, falling back to using String content. For binary content this can be a problem.");
                String charset = IOHelper.getCharsetName((Exchange)exchange, (boolean)true);
                int dataByteLength = data.getBytes(charset).length;
                response.setCharacterEncoding(charset);
                response.setContentLength(dataByteLength);
                try {
                    response.getWriter().print(data);
                }
                finally {
                    response.getWriter().flush();
                }
            }
        }
    }

    protected boolean checkChunked(Message message, Exchange exchange) {
        boolean answer = true;
        if (message.getHeader("CamelHttpChunked") == null) {
            Endpoint endpoint = exchange.getFromEndpoint();
            if (endpoint instanceof HttpEndpoint) {
                answer = ((HttpEndpoint)endpoint).isChunked();
            }
        } else {
            answer = (Boolean)message.getHeader("CamelHttpChunked", Boolean.TYPE);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteGZIPResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        byte[] bytes;
        try {
            bytes = (byte[])message.getMandatoryBody(byte[].class);
        }
        catch (InvalidPayloadException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        byte[] data = GZIPHelper.compressGZIP((byte[])bytes);
        ServletOutputStream os = response.getOutputStream();
        try {
            response.setContentLength(data.length);
            os.write(data);
            os.flush();
        }
        finally {
            IOHelper.close((Closeable)os);
        }
    }

    @Override
    public Object parseBody(HttpMessage httpMessage) throws IOException {
        HttpServletRequest request = httpMessage.getRequest();
        if ("GET".equals(request.getMethod())) {
            return null;
        }
        if (this.isUseReaderForPayload()) {
            return request.getReader();
        }
        return HttpHelper.readResponseBodyFromServletRequest(request, httpMessage.getExchange());
    }

    @Override
    public boolean isUseReaderForPayload() {
        return this.useReaderForPayload;
    }

    @Override
    public void setUseReaderForPayload(boolean useReaderForPayload) {
        this.useReaderForPayload = useReaderForPayload;
    }

    @Override
    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }
}

