/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import java.lang.management.ManagementFactory;
import java.util.UUID;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.management.monitor.CounterMonitor;
import javax.management.monitor.GaugeMonitor;
import javax.management.monitor.Monitor;
import javax.management.monitor.StringMonitor;
import org.apache.camel.Processor;
import org.apache.camel.component.jmx.JMXConsumer;
import org.apache.camel.component.jmx.JMXEndpoint;

public class JMXMonitorConsumer
extends JMXConsumer {
    ObjectName mMonitorObjectName;

    public JMXMonitorConsumer(JMXEndpoint aEndpoint, Processor aProcessor) {
        super(aEndpoint, aProcessor);
    }

    @Override
    protected void addNotificationListener() throws Exception {
        JMXEndpoint ep = (JMXEndpoint)this.getEndpoint();
        Monitor bean = null;
        if (ep.getMonitorType().equals("counter")) {
            CounterMonitor counter = new CounterMonitor();
            counter.setInitThreshold(ep.getInitThreshold());
            counter.setOffset(ep.getOffset());
            counter.setModulus(ep.getModulus());
            counter.setDifferenceMode(ep.isDifferenceMode());
            counter.setNotify(true);
            bean = counter;
        } else if (ep.getMonitorType().equals("gauge")) {
            GaugeMonitor gm = new GaugeMonitor();
            gm.setNotifyHigh(ep.isNotifyHigh());
            gm.setNotifyLow(ep.isNotifyLow());
            gm.setDifferenceMode(ep.isDifferenceMode());
            Object attr = ManagementFactory.getPlatformMBeanServer().getAttribute(ep.getJMXObjectName(), ep.getObservedAttribute());
            Double highValue = ep.getThresholdHigh();
            Double lowValue = ep.getThresholdLow();
            if (attr instanceof Byte) {
                gm.setThresholds(highValue.byteValue(), lowValue.byteValue());
            } else if (attr instanceof Integer) {
                gm.setThresholds(highValue.intValue(), lowValue.intValue());
            } else if (attr instanceof Short) {
                gm.setThresholds(highValue.shortValue(), lowValue.shortValue());
            } else if (attr instanceof Long) {
                gm.setThresholds(highValue.longValue(), lowValue.longValue());
            } else if (attr instanceof Float) {
                gm.setThresholds(Float.valueOf(highValue.floatValue()), Float.valueOf(lowValue.floatValue()));
            } else {
                gm.setThresholds(highValue, lowValue);
            }
            bean = gm;
        } else if (ep.getMonitorType().equals("string")) {
            StringMonitor sm = new StringMonitor();
            sm.setNotifyDiffer(ep.isNotifyDiffer());
            sm.setNotifyMatch(ep.isNotifyMatch());
            sm.setStringToCompare(ep.getStringToCompare());
            bean = sm;
        }
        bean.addObservedObject(ep.getJMXObjectName());
        bean.setObservedAttribute(ep.getObservedAttribute());
        bean.setGranularityPeriod(ep.getGranularityPeriod());
        this.mMonitorObjectName = new ObjectName(ep.getObjectDomain(), "name", "camel-jmx-monitor-" + UUID.randomUUID());
        ManagementFactory.getPlatformMBeanServer().registerMBean(bean, this.mMonitorObjectName);
        NotificationFilter nf = ep.getNotificationFilter();
        this.getServerConnection().addNotificationListener(this.mMonitorObjectName, this, nf, (Object)bean);
        bean.start();
    }

    @Override
    protected void removeNotificationListener() throws Exception {
        ManagementFactory.getPlatformMBeanServer().removeNotificationListener(this.mMonitorObjectName, this);
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.mMonitorObjectName);
    }
}

