/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.hbase.HBaseEndpoint;
import org.apache.camel.component.hbase.HbaseAttribute;
import org.apache.camel.component.hbase.model.HBaseCell;
import org.apache.camel.component.hbase.model.HBaseRow;
import org.apache.camel.impl.DefaultComponent;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTablePool;

public class HBaseComponent
extends DefaultComponent {
    private Configuration configuration;
    private HTablePool tablePool;
    private int poolMaxSize = 10;

    protected void doStart() throws Exception {
        if (this.configuration == null) {
            this.configuration = HBaseConfiguration.create();
        }
        this.tablePool = new HTablePool(this.configuration, this.poolMaxSize);
    }

    protected void doStop() throws Exception {
        if (this.tablePool != null) {
            this.tablePool.close();
        }
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String tableName = remaining;
        HBaseEndpoint endpoint = new HBaseEndpoint(uri, this, this.tablePool, tableName);
        HBaseRow parameterRowModel = this.createRowModel(parameters);
        this.setProperties((Object)endpoint, parameters);
        if (endpoint.getRowModel() == null) {
            endpoint.setRowModel(parameterRowModel);
        }
        return endpoint;
    }

    public HBaseRow createRowModel(Map<String, Object> parameters) {
        String rowType;
        HBaseRow rowModel = new HBaseRow();
        if (parameters.containsKey(HbaseAttribute.HBASE_ROW_TYPE.asOption()) && (rowType = String.valueOf(parameters.remove(HbaseAttribute.HBASE_ROW_TYPE.asOption()))) != null && !rowType.isEmpty()) {
            rowModel.setRowType(this.getCamelContext().getClassResolver().resolveClass(rowType));
        }
        int i = 1;
        while (parameters.get(HbaseAttribute.HBASE_FAMILY.asOption(i)) != null && parameters.get(HbaseAttribute.HBASE_QUALIFIER.asOption(i)) != null) {
            String valueType;
            HBaseCell cellModel = new HBaseCell();
            cellModel.setFamily(String.valueOf(parameters.remove(HbaseAttribute.HBASE_FAMILY.asOption(i))));
            cellModel.setQualifier(String.valueOf(parameters.remove(HbaseAttribute.HBASE_QUALIFIER.asOption(i))));
            cellModel.setValue(String.valueOf(parameters.remove(HbaseAttribute.HBASE_VALUE.asOption(i))));
            if (parameters.containsKey(HbaseAttribute.HBASE_VALUE_TYPE.asOption(i)) && (valueType = String.valueOf(parameters.remove(HbaseAttribute.HBASE_VALUE_TYPE.asOption(i)))) != null && !valueType.isEmpty()) {
                rowModel.setRowType(this.getCamelContext().getClassResolver().resolveClass(valueType));
            }
            rowModel.getCells().add(cellModel);
            ++i;
        }
        return rowModel;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public int getPoolMaxSize() {
        return this.poolMaxSize;
    }

    public void setPoolMaxSize(int poolMaxSize) {
        this.poolMaxSize = poolMaxSize;
    }
}

