/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.hbase.HBaseEndpoint;
import org.apache.camel.component.hbase.HBaseHelper;
import org.apache.camel.component.hbase.HbaseAttribute;
import org.apache.camel.component.hbase.mapping.CellMappingStrategy;
import org.apache.camel.component.hbase.model.HBaseCell;
import org.apache.camel.component.hbase.model.HBaseData;
import org.apache.camel.component.hbase.model.HBaseRow;
import org.apache.camel.impl.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseConsumer.class);
    private String tableName;
    private final HBaseEndpoint endpoint;
    private HTablePool tablePool;
    private HBaseRow rowModel;

    public HBaseConsumer(HBaseEndpoint endpoint, Processor processor, HTablePool tablePool, String tableName) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.tableName = tableName;
        this.tablePool = tablePool;
        this.rowModel = endpoint.getRowModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int poll() throws Exception {
        HTableInterface table = this.tablePool.getTable(this.tableName);
        try {
            this.shutdownRunningTask = null;
            this.pendingExchanges = 0;
            LinkedList<Exchange> queue = new LinkedList<Exchange>();
            Scan scan = new Scan();
            LinkedList<Object> filters = new LinkedList<Object>();
            if (this.endpoint.getFilters() != null) {
                filters.addAll(this.endpoint.getFilters());
            }
            if (this.maxMessagesPerPoll > 0) {
                filters.add(new PageFilter((long)this.maxMessagesPerPoll));
            }
            FilterList compoundFilter = new FilterList(filters);
            scan.setFilter((Filter)compoundFilter);
            if (this.rowModel != null && this.rowModel.getCells() != null) {
                Set<HBaseCell> cellModels = this.rowModel.getCells();
                for (HBaseCell cellModel : cellModels) {
                    scan.addColumn(HBaseHelper.getHBaseFieldAsBytes(cellModel.getFamily()), HBaseHelper.getHBaseFieldAsBytes(cellModel.getQualifier()));
                }
            }
            ResultScanner scanner = table.getScanner(scan);
            int exchangeCount = 0;
            Exchange exchange = this.endpoint.createExchange();
            exchange.getIn().setHeader("CamelMappingStrategy", (Object)"body");
            CellMappingStrategy mappingStrategy = this.endpoint.getCellMappingStrategyFactory().getStrategy(exchange.getIn());
            Result result = scanner.next();
            while ((exchangeCount < this.maxMessagesPerPoll || this.maxMessagesPerPoll <= 0) && result != null) {
                HBaseData data = new HBaseData();
                HBaseRow resultRow = new HBaseRow();
                resultRow.apply(this.rowModel);
                byte[] row = result.getRow();
                resultRow.setId(this.endpoint.getCamelContext().getTypeConverter().convertTo(this.rowModel.getRowType(), (Object)row));
                List keyValues = result.list();
                if (keyValues != null) {
                    for (KeyValue keyValue : keyValues) {
                        String qualifier = new String(keyValue.getQualifier());
                        String family = new String(keyValue.getFamily());
                        HBaseCell resultCell = new HBaseCell();
                        resultCell.setFamily(family);
                        resultCell.setQualifier(qualifier);
                        resultCell.setValue(this.endpoint.getCamelContext().getTypeConverter().convertTo(String.class, (Object)keyValue.getValue()));
                        resultRow.getCells().add(resultCell);
                    }
                    data.getRows().add(resultRow);
                    exchange = this.endpoint.createExchange();
                    exchange.getIn().setHeader("CamelMappingStrategy", (Object)"body");
                    mappingStrategy.applyScanResults(exchange.getIn(), data);
                    exchange.getIn().setHeader(HbaseAttribute.HBASE_MARKED_ROW_ID.asHeader(), (Object)result.getRow());
                    queue.add(exchange);
                    ++exchangeCount;
                }
                result = scanner.next();
            }
            scanner.close();
            int n = queue.isEmpty() ? 0 : this.processBatch(CastUtils.cast(queue));
            return n;
        }
        finally {
            table.close();
        }
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        if (this.maxMessagesPerPoll > 0 && total > this.maxMessagesPerPoll) {
            LOG.debug("Limiting to maximum messages to poll {} as there was {} messages in this poll.", (Object)this.maxMessagesPerPoll, (Object)total);
            total = this.maxMessagesPerPoll;
        }
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            LOG.trace("Processing exchange [{}]...", (Object)exchange);
            this.getProcessor().process(exchange);
            if (exchange.getException() != null) {
                throw exchange.getException();
            }
            if (!this.endpoint.isRemove()) continue;
            this.remove((byte[])exchange.getIn().getHeader(HbaseAttribute.HBASE_MARKED_ROW_ID.asHeader()));
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(byte[] row) throws IOException {
        HTableInterface table = this.tablePool.getTable(this.tableName);
        try {
            this.endpoint.getRemoveHandler().remove(table, row);
        }
        finally {
            table.close();
        }
    }

    public HBaseRow getRowModel() {
        return this.rowModel;
    }

    public void setRowModel(HBaseRow rowModel) {
        this.rowModel = rowModel;
    }
}

