/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lucene;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.camel.component.lucene.LuceneComponent;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;

public class LuceneConfiguration {
    private URI uri;
    private String protocolType;
    private String authority;
    private String host;
    private String operation;
    private File sourceDirectory;
    private File indexDirectory;
    private Analyzer analyzer;
    private int maxHits;
    private Version luceneVersion = Version.LUCENE_35;

    public LuceneConfiguration() {
    }

    public LuceneConfiguration(URI uri) throws Exception {
        this.uri = uri;
    }

    public void parseURI(URI uri, Map<String, Object> parameters, LuceneComponent component) throws Exception {
        String protocol = uri.getScheme();
        if (!protocol.equalsIgnoreCase("lucene")) {
            throw new IllegalArgumentException("Unrecognized Lucene protocol: " + protocol + " for uri: " + uri);
        }
        this.setUri(uri);
        this.setAuthority(uri.getAuthority());
        if (!this.isValidAuthority()) {
            throw new URISyntaxException(uri.toASCIIString(), "Incorrect URI syntax and/or Operation specified for the Lucene endpoint.Please specify the syntax as \"lucene:[Endpoint Name]:[Operation]?[Query]\"");
        }
        this.setHost(this.retrieveTokenFromAuthority("hostname"));
        this.setOperation(this.retrieveTokenFromAuthority("operation"));
        this.sourceDirectory = (File)component.resolveAndRemoveReferenceParameter(parameters, "srcDir", File.class, null);
        this.indexDirectory = (File)component.resolveAndRemoveReferenceParameter(parameters, "indexDir", File.class, new File("file:///./indexDirectory"));
        this.analyzer = (Analyzer)component.resolveAndRemoveReferenceParameter(parameters, "analyzer", Analyzer.class, new StandardAnalyzer(this.luceneVersion));
        this.setMaxHits((Integer)component.getAndRemoveParameter(parameters, "maxHits", Integer.class, 10));
    }

    private boolean isValidAuthority() throws URISyntaxException {
        return this.authority.contains(":") && this.authority.split(":")[0] != null && (this.authority.split(":")[1].equalsIgnoreCase("insert") || this.authority.split(":")[1].equalsIgnoreCase("query"));
    }

    private String retrieveTokenFromAuthority(String token) throws URISyntaxException {
        String retval = token.equalsIgnoreCase("hostname") ? this.uri.getAuthority().split(":")[0] : this.uri.getAuthority().split(":")[1];
        return retval;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public void setProtocolType(String protocolType) {
        this.protocolType = protocolType;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public File getIndexDirectory() {
        return this.indexDirectory;
    }

    public void setIndexDirectory(File indexDirectory) {
        this.indexDirectory = indexDirectory;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public int getMaxHits() {
        return this.maxHits;
    }

    public void setMaxHits(int maxHits) {
        this.maxHits = maxHits;
    }

    public void setLuceneVersion(Version luceneVersion) {
        this.luceneVersion = luceneVersion;
    }

    public Version getLuceneVersion() {
        return this.luceneVersion;
    }
}

