/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.guava.eventbus;

import com.google.common.eventbus.EventBus;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.guava.eventbus.CamelEventHandler;
import org.apache.camel.component.guava.eventbus.GuavaEventBusEndpoint;
import org.apache.camel.impl.DefaultConsumer;

public class GuavaEventBusConsumer
extends DefaultConsumer {
    private final EventBus eventBus;
    private final CamelEventHandler eventHandler;

    public GuavaEventBusConsumer(GuavaEventBusEndpoint endpoint, Processor processor, EventBus eventBus, Class<?> eventClass) {
        super((Endpoint)endpoint, processor);
        this.eventBus = eventBus;
        this.eventHandler = new CamelEventHandler(endpoint, processor, eventClass);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.log.debug("Registering event handler: {} to EventBus: {}", (Object)this.eventHandler, (Object)this.eventBus);
        this.eventBus.register((Object)this.eventHandler);
    }

    protected void doStop() throws Exception {
        this.log.debug("Unregistering event handler: {} from EventBus: {}", (Object)this.eventHandler, (Object)this.eventBus);
        this.eventBus.unregister((Object)this.eventHandler);
        super.doStop();
    }
}

