/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.guava.eventbus;

import com.google.common.eventbus.EventBus;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.guava.eventbus.GuavaEventBusConsumer;
import org.apache.camel.component.guava.eventbus.GuavaEventBusProducer;
import org.apache.camel.impl.DefaultEndpoint;

public class GuavaEventBusEndpoint
extends DefaultEndpoint {
    private EventBus eventBus;
    private Class<?> eventClass;

    public GuavaEventBusEndpoint(String endpointUri, Component component, EventBus eventBus) {
        super(endpointUri, component);
        this.eventBus = eventBus;
    }

    public Producer createProducer() throws Exception {
        return new GuavaEventBusProducer((Endpoint)this, this.eventBus);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new GuavaEventBusConsumer(this, processor, this.eventBus, this.eventClass);
    }

    public boolean isSingleton() {
        return true;
    }

    public Exchange createExchange(Object event) {
        Exchange exchange = this.createExchange();
        exchange.getIn().setBody(event);
        return exchange;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public Class<?> getEventClass() {
        return this.eventClass;
    }

    public void setEventClass(Class<?> eventClass) {
        this.eventClass = eventClass;
    }
}

